/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.test;

import java.util.List;
import java.util.Map;
import org.javarosa.test.XFormsElement;

class TagXFormsElement
implements XFormsElement {
    private final String name;
    private final Map<String, String> attributes;
    private final List<XFormsElement> children;

    TagXFormsElement(String name, Map<String, String> attributes, List<XFormsElement> children) {
        assert (!children.isEmpty());
        this.name = name;
        this.attributes = attributes;
        this.children = children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String asXml() {
        String attributesString = XFormsElement.buildAttributesString(this.attributes);
        StringBuilder childrenStringBuilder = new StringBuilder();
        for (XFormsElement e : this.children) {
            childrenStringBuilder.append(e.asXml());
        }
        return String.format("%s<%s%s>%s</%s>", this.name.equals("h:html") ? "<?xml version=\"1.0\"?>" : "", this.name, attributesString.isEmpty() ? "" : " " + attributesString, childrenStringBuilder, this.name);
    }
}

