/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javarosa.core.model.instance.CsvExternalInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.XmlExternalInstance;
import org.javarosa.core.model.instance.geojson.GeoJsonExternalInstance;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParserException;

public class ExternalInstanceParser {
    private List<FileInstanceParser> fileInstanceParsers = Arrays.asList(new CsvExternalInstance(), new GeoJsonExternalInstance());
    private List<InstanceProvider> instanceProviders = Collections.emptyList();

    public TreeElement parse(ReferenceManager referenceManager, String instanceId, String instanceSrc, boolean partial) throws IOException, UnfullfilledRequirementsException, InvalidStructureException, XmlPullParserException, InvalidReferenceException {
        Optional<InstanceProvider> instanceProvider = this.instanceProviders.stream().filter(parser -> parser.isSupported(instanceId, instanceSrc)).findFirst();
        if (instanceProvider.isPresent()) {
            return instanceProvider.get().get(instanceId, instanceSrc, partial);
        }
        String path = ExternalInstanceParser.getPath(referenceManager, instanceSrc);
        Optional<FileInstanceParser> fileParser = this.fileInstanceParsers.stream().filter(parser -> parser.isSupported(instanceId, instanceSrc)).findFirst();
        TreeElement root = fileParser.isPresent() ? fileParser.get().parse(instanceId, path, partial) : XmlExternalInstance.parse(instanceId, path);
        return root;
    }

    public TreeElement parse(ReferenceManager referenceManager, String instanceId, String instanceSrc) throws IOException, UnfullfilledRequirementsException, InvalidStructureException, XmlPullParserException, InvalidReferenceException {
        return this.parse(referenceManager, instanceId, instanceSrc, false);
    }

    public void addFileInstanceParser(FileInstanceParser fileInstanceParser) {
        this.fileInstanceParsers = Stream.concat(Stream.of(fileInstanceParser), this.fileInstanceParsers.stream()).collect(Collectors.toList());
    }

    public void addInstanceProvider(InstanceProvider instanceProvider) {
        this.instanceProviders = Stream.concat(Stream.of(instanceProvider), this.instanceProviders.stream()).collect(Collectors.toList());
    }

    private static String getPath(ReferenceManager referenceManager, String srcLocation) throws InvalidReferenceException {
        String uri = referenceManager.deriveReference(srcLocation).getLocalURI();
        return uri.startsWith("//") ? uri.substring(1) : uri;
    }

    public static interface InstanceProvider {
        public TreeElement get(@NotNull String var1, @NotNull String var2) throws IOException;

        default public TreeElement get(@NotNull String instanceId, @NotNull String instanceSrc, boolean partial) throws IOException {
            return this.get(instanceId, instanceSrc);
        }

        public boolean isSupported(@NotNull String var1, @NotNull String var2);
    }

    public static interface FileInstanceParser {
        public TreeElement parse(@NotNull String var1, @NotNull String var2) throws IOException;

        default public TreeElement parse(@NotNull String instanceId, @NotNull String path, boolean partial) throws IOException {
            return this.parse(instanceId, path);
        }

        public boolean isSupported(@NotNull String var1, @NotNull String var2);
    }
}

