/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.javarosa.core.model.CompareToNodeExpression;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.FilterStrategy;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.expr.XPathBoolExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.jetbrains.annotations.NotNull;

public class ComparisonExpressionCacheFilterStrategy
implements FilterStrategy {
    private final Map<String, List<TreeReference>> cachedEvaluations = new HashMap<String, List<TreeReference>>();

    @Override
    @NotNull
    public List<TreeReference> filter(@NotNull DataInstance sourceInstance, @NotNull TreeReference nodeSet, @NotNull XPathExpression predicate, @NotNull List<TreeReference> children, @NotNull EvaluationContext evaluationContext, @NotNull Supplier<List<TreeReference>> next) {
        if (sourceInstance.getInstanceId() == null) {
            return next.get();
        }
        CompareToNodeExpression candidate = CompareToNodeExpression.parse(predicate);
        if (candidate != null) {
            String key = ComparisonExpressionCacheFilterStrategy.getExpressionKey(sourceInstance, nodeSet, predicate, evaluationContext, candidate);
            return this.getCachedEvaluations(next, key);
        }
        if (predicate instanceof XPathBoolExpr) {
            XPathExpression a = ((XPathBoolExpr)predicate).a;
            XPathExpression b = ((XPathBoolExpr)predicate).b;
            CompareToNodeExpression candidateA = CompareToNodeExpression.parse(a);
            CompareToNodeExpression candidateB = CompareToNodeExpression.parse(b);
            if (candidateA != null && candidateB != null) {
                String keyA = ComparisonExpressionCacheFilterStrategy.getExpressionKey(sourceInstance, nodeSet, a, evaluationContext, candidateA);
                String keyB = ComparisonExpressionCacheFilterStrategy.getExpressionKey(sourceInstance, nodeSet, b, evaluationContext, candidateB);
                String key = "XPathBoolExpr:" + ((XPathBoolExpr)predicate).op + keyA + keyB;
                return this.getCachedEvaluations(next, key);
            }
            return next.get();
        }
        return next.get();
    }

    private synchronized List<TreeReference> getCachedEvaluations(@NotNull Supplier<List<TreeReference>> next, String key) {
        if (this.cachedEvaluations.containsKey(key)) {
            return this.cachedEvaluations.get(key);
        }
        List<TreeReference> filtered = next.get();
        this.cachedEvaluations.put(key, filtered);
        return filtered;
    }

    @NotNull
    private static String getExpressionKey(@NotNull DataInstance sourceInstance, @NotNull TreeReference nodeSet, @NotNull XPathExpression predicate, @NotNull EvaluationContext evaluationContext, CompareToNodeExpression candidate) {
        Object absoluteValue = candidate.evalContextSide(sourceInstance, evaluationContext);
        return nodeSet.toString() + predicate + candidate.getNodeSide() + absoluteValue.toString();
    }
}

