/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.log.WrappedException;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.RestoreUtils;

public class ChoiceNameFunctionHandler
implements IFunctionHandler {
    FormDef f;

    public ChoiceNameFunctionHandler(FormDef f) {
        this.f = f;
    }

    @Override
    public String getName() {
        return "jr:choice-name";
    }

    @Override
    public Object eval(Object[] args, EvaluationContext ec) {
        try {
            List<SelectChoice> choices;
            String value = (String)args[0];
            String questionXpath = (String)args[1];
            TreeReference ref = RestoreUtils.xfFact.ref(questionXpath);
            ref = ref.anchor(ec.getContextRef());
            QuestionDef q = FormDef.findQuestionByRef(ref, this.f);
            if (q == null || q.getControlType() != 2 && q.getControlType() != 3 && q.getControlType() != 16) {
                return "";
            }
            ItemsetBinding itemset = q.getDynamicChoices();
            if (itemset != null) {
                if (ref.isAmbiguous()) {
                    ref = ref.contextualize(ec.getContextRef());
                    for (int i = 0; i < ref.size(); ++i) {
                        if (ref.getMultiplicity(i) != -1) continue;
                        ref.setMultiplicity(i, 0);
                    }
                }
                choices = itemset.getChoices(this.f, ref);
            } else {
                choices = q.getChoices();
            }
            if (choices != null) {
                for (SelectChoice ch : choices) {
                    if (!ch.getValue().equals(value)) continue;
                    String textID = ch.getTextID();
                    String templateStr = textID != null ? this.f.getLocalizer().getText(textID) : ch.getLabelInnerText();
                    return this.f.fillTemplateString(templateStr, ref);
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new WrappedException("error in evaluation of xpath function [choice-name]", e);
        }
    }

    @Override
    public List<Class[]> getPrototypes() {
        Class[] proto = new Class[]{String.class, String.class};
        ArrayList<Class[]> v = new ArrayList<Class[]>(1);
        v.add(proto);
        return v;
    }

    @Override
    public boolean rawArgs() {
        return false;
    }

    @Override
    public boolean realTime() {
        return false;
    }
}

