/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.IExprDataType;
import org.jetbrains.annotations.NotNull;

public class GeoTraceData
implements IAnswerData,
IExprDataType {
    public final ArrayList<GeoPointData> points = new ArrayList();

    public GeoTraceData() {
    }

    public GeoTraceData(GeoTraceData data) {
        for (GeoPointData p : data.points) {
            this.points.add(new GeoPointData(p));
        }
    }

    public GeoTraceData(GeoTrace atrace) {
        for (double[] da : atrace.points) {
            this.points.add(new GeoPointData(da));
        }
    }

    @Override
    public IAnswerData clone() {
        return new GeoTraceData(this);
    }

    @Override
    public String getDisplayText() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (GeoPointData p : this.points) {
            if (!first) {
                b.append("; ");
            }
            first = false;
            b.append(p.getDisplayText());
        }
        return b.toString();
    }

    @Override
    @NotNull
    public Object getValue() {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        for (GeoPointData p : this.points) {
            pts.add((double[])p.getValue());
        }
        return new GeoTrace(pts);
    }

    @Override
    public void setValue(@NotNull Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        if (!(o instanceof GeoTrace)) {
            GeoTraceData t = new GeoTraceData();
            GeoTraceData v = t.cast(new UncastData(o.toString()));
            o = v.getValue();
        }
        GeoTrace gs = (GeoTrace)o;
        ArrayList<GeoPointData> temp = new ArrayList<GeoPointData>();
        for (double[] da : gs.points) {
            temp.add(new GeoPointData(da));
        }
        this.points.clear();
        this.points.addAll(temp);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.points.clear();
        int len = (int)ExtUtil.readNumeric(in);
        for (int i = 0; i < len; ++i) {
            GeoPointData t = new GeoPointData();
            t.readExternal(in, pf);
            this.points.add(t);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.points.size());
        for (GeoPointData t : this.points) {
            t.writeExternal(out);
        }
    }

    @Override
    public UncastData uncast() {
        return new UncastData(this.getDisplayText());
    }

    @Override
    public GeoTraceData cast(UncastData data) throws IllegalArgumentException {
        String[] parts = data.value.split(";");
        GeoPointData t = new GeoPointData();
        GeoTraceData d = new GeoTraceData();
        for (String part : parts) {
            d.points.add(t.cast(new UncastData(part.trim())));
        }
        return d;
    }

    @Override
    public Boolean toBoolean() {
        return !this.points.isEmpty();
    }

    @Override
    public Double toNumeric() {
        if (this.points.size() == 0) {
            return 9999999.0;
        }
        double maxValue = 0.0;
        for (GeoPointData p : this.points) {
            maxValue = Math.max(maxValue, p.toNumeric());
        }
        return maxValue;
    }

    @Override
    public String toString() {
        return this.getDisplayText();
    }

    public static class GeoTrace {
        public final ArrayList<double[]> points;

        public GeoTrace() {
            this.points = new ArrayList();
        }

        public GeoTrace(ArrayList<double[]> points) {
            this.points = points;
        }
    }
}

