/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.jetbrains.annotations.NotNull;

public class IntegerData
implements IAnswerData {
    private int n;

    public IntegerData() {
    }

    public IntegerData(int n) {
        this.n = n;
    }

    @Override
    public IAnswerData clone() {
        return new IntegerData(this.n);
    }

    @Override
    public String getDisplayText() {
        return String.valueOf(this.n);
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.n;
    }

    @Override
    public void setValue(@NotNull Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.n = (Integer)o;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.n = ExtUtil.readInt(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.n);
    }

    @Override
    public UncastData uncast() {
        return new UncastData(Integer.valueOf(this.n).toString());
    }

    @Override
    public IntegerData cast(UncastData data) throws IllegalArgumentException {
        try {
            return new IntegerData(Integer.parseInt(data.value));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid cast of data [" + data.value + "] to type Decimal");
        }
    }

    public String toString() {
        return "IntegerData{n=" + this.n + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerData that = (IntegerData)o;
        return this.n == that.n;
    }

    public int hashCode() {
        return Objects.hash(this.n);
    }
}

