/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.jetbrains.annotations.NotNull;

public class TimeData
implements IAnswerData {
    Date d;

    public TimeData() {
    }

    public TimeData(@NotNull Date d) {
        this.setValue(d);
    }

    @Override
    public IAnswerData clone() {
        return new TimeData(new Date(this.d.getTime()));
    }

    @Override
    public void setValue(@NotNull Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.d = new Date(((Date)o).getTime());
    }

    @Override
    @NotNull
    public Object getValue() {
        return new Date(this.d.getTime());
    }

    @Override
    public String getDisplayText() {
        return DateUtils.formatTime(this.d, 2);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.setValue(ExtUtil.readDate(in));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeDate(out, this.d);
    }

    @Override
    public UncastData uncast() {
        return new UncastData(DateUtils.formatTime(this.d, 1));
    }

    @Override
    public TimeData cast(UncastData data) throws IllegalArgumentException {
        Date ret = DateUtils.parseTime(data.value);
        if (ret != null) {
            return new TimeData(ret);
        }
        throw new IllegalArgumentException("Invalid cast of data [" + data.value + "] to type Time");
    }
}

