/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.CompactInstanceWrapper;
import org.javarosa.core.model.instance.utils.DefaultAnswerResolver;
import org.javarosa.core.model.instance.utils.IAnswerResolver;
import org.javarosa.core.model.instance.utils.ITreeVisitor;
import org.javarosa.core.model.instance.utils.TreeElementChildrenList;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.util.DataUtil;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.jetbrains.annotations.Nullable;

public class TreeElement
implements Externalizable,
AbstractTreeElement<TreeElement> {
    private String name;
    protected int multiplicity = -1;
    private AbstractTreeElement parent;
    private IAnswerData value;
    private List<FormElementStateListener> observers;
    private List<TreeElement> attributes;
    private final TreeElementChildrenList children = new TreeElementChildrenList();
    protected int dataType = 0;
    private Constraint constraint = null;
    private String preloadHandler = null;
    private String preloadParams = null;
    private List<TreeElement> bindAttributes = new ArrayList<TreeElement>(0);
    private static final int MASK_REQUIRED = 1;
    private static final int MASK_REPEATABLE = 2;
    private static final int MASK_ATTRIBUTE = 4;
    private static final int MASK_RELEVANT = 8;
    private static final int MASK_ENABLED = 16;
    private static final int MASK_RELEVANT_INH = 32;
    private static final int MASK_ENABLED_INH = 64;
    private int flags = 120;
    private String namespace;
    private String namespacePrefix;
    private String instanceName = null;
    private boolean isPartial;
    final TreeReference[] refCache = new TreeReference[1];

    public TreeElement() {
        this(null, 0);
    }

    public TreeElement(String name) {
        this(name, 0);
    }

    public TreeElement(String name, int multiplicity) {
        this.name = name;
        this.multiplicity = multiplicity;
        this.parent = null;
        this.attributes = new ArrayList<TreeElement>(0);
    }

    public TreeElement(String name, int multiplicity, boolean isPartial) {
        this(name, multiplicity);
        this.isPartial = isPartial;
    }

    public static TreeElement constructAttributeElement(String namespace, String name, String value) {
        TreeElement element = new TreeElement(name);
        element.setIsAttribute(true);
        element.namespace = namespace == null ? "" : namespace;
        element.multiplicity = -4;
        element.value = new UncastData(value);
        return element;
    }

    private void setIsAttribute(boolean attribute) {
        this.setMaskVar(4, attribute);
    }

    public static TreeElement getAttribute(List<TreeElement> attributes, String namespace, String name) {
        for (TreeElement attribute : attributes) {
            if (!attribute.getName().equals(name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute;
        }
        return null;
    }

    public static void setAttribute(TreeElement parent, List<TreeElement> attrs, String namespace, String name, String value) {
        TreeElement attribut = TreeElement.getAttribute(attrs, namespace, name);
        if (attribut != null) {
            if (value == null) {
                attrs.remove(attribut);
            } else {
                attribut.setValue(new UncastData(value));
            }
            return;
        }
        if (value == null) {
            return;
        }
        TreeElement attr = TreeElement.constructAttributeElement(namespace, name, value);
        attr.setParent(parent);
        attrs.add(attr);
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public boolean isChildable() {
        return this.value == null;
    }

    @Override
    public String getInstanceName() {
        if (this.parent != null) {
            return this.parent.getInstanceName();
        }
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setValue(IAnswerData value) {
        if (!this.isLeaf()) {
            throw new RuntimeException("Can't set data value for node that has children!");
        }
        this.value = value;
    }

    @Override
    @Nullable
    public TreeElement getFirstChild(String name) {
        return this.getChild(name, 0);
    }

    @Override
    @Nullable
    public TreeElement getFirstChild(String namespace, String name) {
        TreeElement firstChild = this.getFirstChild(name);
        if (firstChild == null || firstChild.getNamespace().equals(namespace)) {
            return firstChild;
        }
        return null;
    }

    @Override
    @Nullable
    public TreeElement getChild(String name, int multiplicity) {
        return this.children.get(name, multiplicity);
    }

    @Override
    public List<TreeElement> getChildrenWithName(String name) {
        return this.children.get(name);
    }

    private int getNumChildrenWithName(String name) {
        return this.children.getCount(name);
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public boolean hasChildren() {
        return this.getNumChildren() > 0;
    }

    @Override
    public TreeElement getChildAt(int i) {
        return this.children.get(i);
    }

    @Override
    public boolean isRepeatable() {
        return this.getMaskVar(2);
    }

    @Override
    public boolean isAttribute() {
        return this.getMaskVar(4);
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public void addChild(TreeElement child) {
        if (!this.isChildable()) {
            throw new RuntimeException("Can't add children to node that has data value!");
        }
        if (child.multiplicity == -1) {
            throw new RuntimeException("Cannot add child with an unbound index!");
        }
        this.children.addInOrder(child);
        child.setParent(this);
        child.setRelevant(this.isRelevant(), true);
        child.setEnabled(this.isEnabled(), true);
        child.setInstanceName(this.getInstanceName());
    }

    public void removeChild(TreeElement child) {
        this.children.remove(child);
    }

    public void removeChild(String name, int multiplicity) {
        this.children.remove(name, multiplicity);
    }

    public void removeChildren(String name) {
        this.children.removeAll(name);
    }

    public void removeChildAt(int i) {
        this.children.remove(i);
    }

    @Override
    public int getChildMultiplicity(String name) {
        return this.getNumChildrenWithName(name);
    }

    public TreeElement shallowCopy() {
        TreeElement newNode = new TreeElement(this.name, this.multiplicity);
        newNode.parent = this.parent;
        newNode.setRepeatable(this.isRepeatable());
        newNode.dataType = this.dataType;
        newNode.setMaskVar(8, this.getMaskVar(8));
        newNode.setMaskVar(1, this.getMaskVar(1));
        newNode.setMaskVar(16, this.getMaskVar(16));
        newNode.constraint = this.constraint;
        newNode.preloadHandler = this.preloadHandler;
        newNode.preloadParams = this.preloadParams;
        newNode.instanceName = this.instanceName;
        newNode.namespace = this.namespace;
        newNode.bindAttributes = this.bindAttributes;
        newNode.attributes = new ArrayList<TreeElement>(this.attributes.size());
        for (TreeElement attr : this.attributes) {
            newNode.setAttribute(attr.getNamespace(), attr.getName(), attr.getAttributeValue());
        }
        if (this.value != null) {
            newNode.value = this.value.clone();
        }
        newNode.children.addAll(this.children);
        return newNode;
    }

    public TreeElement deepCopy(boolean includeTemplates) {
        TreeElement newNode = this.shallowCopy();
        newNode.children.clear();
        for (TreeElement child : this.children) {
            if (!includeTemplates && child.getMult() == -2) continue;
            newNode.addChild(child.deepCopy(includeTemplates));
        }
        return newNode;
    }

    @Override
    public boolean isRelevant() {
        return this.getMaskVar(32) && this.getMaskVar(8);
    }

    public boolean isEnabled() {
        return this.getMaskVar(64) && this.getMaskVar(16);
    }

    public boolean setAnswer(IAnswerData answer) {
        if (this.value != null || answer != null) {
            this.setValue(answer);
            this.alertStateObservers(1);
            return true;
        }
        return false;
    }

    public void setRequired(boolean required) {
        if (this.getMaskVar(1) != required) {
            this.setMaskVar(1, required);
            this.alertStateObservers(16);
        }
    }

    private boolean getMaskVar(int mask) {
        return (this.flags & mask) == mask;
    }

    private void setMaskVar(int mask, boolean value) {
        this.flags = value ? (this.flags |= mask) : (this.flags &= Integer.MAX_VALUE - mask);
    }

    public void setRelevant(boolean relevant) {
        this.setRelevant(relevant, false);
    }

    private void setRelevant(boolean relevant, boolean inherited) {
        boolean oldRelevancy = this.isRelevant();
        if (inherited) {
            this.setMaskVar(32, relevant);
        } else {
            this.setMaskVar(8, relevant);
        }
        boolean newRelevant = this.isRelevant();
        if (newRelevant != oldRelevancy) {
            if (this.attributes != null) {
                for (TreeElement attribute : this.attributes) {
                    attribute.setRelevant(newRelevant, true);
                }
            }
            for (TreeElement aChildren : this.children) {
                aChildren.setRelevant(newRelevant, true);
            }
            this.alertStateObservers(8);
        }
    }

    public void setBindAttributes(List<TreeElement> bindAttributes) {
        for (TreeElement ref : bindAttributes) {
            this.setBindAttribute(ref.getNamespace(), ref.getName(), ref.getAttributeValue());
        }
    }

    public List<TreeElement> getBindAttributes() {
        return this.bindAttributes;
    }

    public TreeElement getBindAttribute(String namespace, String name) {
        return TreeElement.getAttribute(this.bindAttributes, namespace, name);
    }

    public String getBindAttributeValue(String namespace, String name) {
        TreeElement element = this.getBindAttribute(namespace, name);
        return element == null ? null : this.getAttributeValue(element);
    }

    public void setBindAttribute(String namespace, String name, String value) {
        TreeElement.setAttribute(this, this.bindAttributes, namespace, name, value);
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, false);
    }

    public void setEnabled(boolean enabled, boolean inherited) {
        boolean oldEnabled = this.isEnabled();
        if (inherited) {
            this.setMaskVar(64, enabled);
        } else {
            this.setMaskVar(16, enabled);
        }
        if (this.isEnabled() != oldEnabled) {
            if (this.children != null) {
                for (TreeElement aChildren : this.children) {
                    aChildren.setEnabled(this.isEnabled(), true);
                }
            }
            this.alertStateObservers(4);
        }
    }

    public void registerStateObserver(FormElementStateListener qsl) {
        if (this.observers == null) {
            this.observers = new ArrayList<FormElementStateListener>(1);
        }
        if (!this.observers.contains(qsl)) {
            this.observers.add(qsl);
        }
    }

    public void unregisterStateObserver(FormElementStateListener qsl) {
        if (this.observers != null) {
            this.observers.remove(qsl);
            if (this.observers.isEmpty()) {
                this.observers = null;
            }
        }
    }

    public void unregisterAll() {
        this.observers = null;
    }

    public void alertStateObservers(int changeFlags) {
        if (this.observers != null) {
            for (FormElementStateListener observer : this.observers) {
                observer.formElementStateChanged(this, changeFlags);
            }
        }
    }

    @Override
    public void accept(ITreeVisitor visitor) {
        visitor.visit(this);
        for (TreeElement child : this.children) {
            child.accept(visitor);
        }
    }

    @Override
    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.attributes.get((int)index).namespace;
    }

    @Override
    public String getAttributeName(int index) {
        return this.attributes.get((int)index).name;
    }

    @Override
    public String getAttributeValue(int index) {
        return this.getAttributeValue(this.attributes.get(index));
    }

    private String getAttributeValue(TreeElement attribute) {
        if (attribute.getValue() == null) {
            return null;
        }
        return attribute.getValue().uncast().getString();
    }

    @Nullable
    public String getAttributeValue() {
        if (!this.isAttribute()) {
            throw new IllegalStateException("this is not an attribute");
        }
        IAnswerData value = this.getValue();
        if (value != null) {
            return value.uncast().getString();
        }
        return null;
    }

    @Override
    public TreeElement getAttribute(String namespace, String name) {
        return TreeElement.getAttribute(this.attributes, namespace, name);
    }

    @Override
    @Nullable
    public String getAttributeValue(String namespace, String name) {
        TreeElement element = this.getAttribute(namespace, name);
        return element == null ? null : this.getAttributeValue(element);
    }

    public void setAttribute(String namespace, String name, String value) {
        TreeElement.setAttribute(this, this.attributes, namespace, name, value);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.name = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.multiplicity = ExtUtil.readInt(in);
        this.flags = ExtUtil.readInt(in);
        this.value = (IAnswerData)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        if (!ExtUtil.readBool(in)) {
            this.children.clear();
        } else {
            int numChildren = (int)ExtUtil.readNumeric(in);
            this.children.clear();
            ArrayList<TreeElement> newChildren = new ArrayList<TreeElement>(numChildren);
            for (int i = 0; i < numChildren; ++i) {
                TreeElement child;
                boolean normal = ExtUtil.readBool(in);
                if (normal) {
                    child = new TreeElement();
                    child.readExternal(in, pf);
                } else {
                    child = (TreeElement)ExtUtil.read(in, new ExtWrapTagged(), pf);
                }
                child.setParent(this);
                newChildren.add(child);
            }
            this.children.addAll(newChildren);
        }
        this.dataType = ExtUtil.readInt(in);
        this.instanceName = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.constraint = (Constraint)ExtUtil.read(in, new ExtWrapNullable(Constraint.class), pf);
        this.preloadHandler = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.preloadParams = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.namespace = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.bindAttributes = ExtUtil.readAttributes(in, this);
        this.attributes = ExtUtil.readAttributes(in, this);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.name));
        ExtUtil.writeNumeric(out, this.multiplicity);
        ExtUtil.writeNumeric(out, this.flags);
        ExtUtil.write(out, new ExtWrapNullable(this.value == null ? null : new ExtWrapTagged(this.value)));
        if (this.children.isEmpty()) {
            ExtUtil.writeBool(out, false);
        } else {
            ExtUtil.writeBool(out, true);
            ExtUtil.writeNumeric(out, this.children.size());
            for (TreeElement child : this.children) {
                if (child.getClass() == TreeElement.class) {
                    ExtUtil.writeBool(out, true);
                    child.writeExternal(out);
                    continue;
                }
                ExtUtil.writeBool(out, false);
                ExtUtil.write(out, new ExtWrapTagged(child));
            }
        }
        ExtUtil.writeNumeric(out, this.dataType);
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.instanceName));
        ExtUtil.write(out, new ExtWrapNullable(this.constraint));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.preloadHandler));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.preloadParams));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.namespace));
        ExtUtil.writeAttributes(out, this.bindAttributes);
        ExtUtil.writeAttributes(out, this.attributes);
    }

    public void populate(TreeElement incoming, FormDef f) {
        if (this.isLeaf()) {
            IAnswerData value = incoming.getValue();
            if (value == null) {
                this.setValue(null);
            } else if (this.dataType == 1 || this.dataType == 0) {
                this.setValue(value);
            } else {
                String textVal = (String)value.getValue();
                IAnswerResolver answerResolver = XFormParser.getAnswerResolver();
                if (answerResolver == null) {
                    answerResolver = new DefaultAnswerResolver();
                }
                this.setValue(answerResolver.resolveAnswer(textVal, this, f));
            }
        } else {
            TreeElement child;
            int i;
            ArrayList<String> names = new ArrayList<String>(this.getNumChildren());
            for (i = 0; i < this.getNumChildren(); ++i) {
                child = this.getChildAt(i);
                if (names.contains(child.getName())) continue;
                names.add(child.getName());
            }
            for (i = 0; i < this.getNumChildren(); ++i) {
                child = this.getChildAt(i);
                if (!child.getMaskVar(2) || child.getMult() == -2) continue;
                this.removeChildAt(i);
                --i;
            }
            if (this.getNumChildren() != names.size()) {
                throw new RuntimeException("sanity check failed");
            }
            for (i = 0; i < this.getNumChildren(); ++i) {
                int j;
                child = this.getChildAt(i);
                String expectedName = (String)names.get(i);
                if (child.getName().equals(expectedName)) continue;
                TreeElement child2 = null;
                for (j = i + 1; j < this.getNumChildren() && !(child2 = this.getChildAt(j)).getName().equals(expectedName); ++j) {
                }
                if (j == this.getNumChildren()) {
                    throw new RuntimeException("sanity check failed");
                }
                this.removeChildAt(j);
                this.children.add(i, child2);
            }
            for (i = 0; i < this.getNumChildren(); ++i) {
                child = this.getChildAt(i);
                List<TreeElement> newChildren = incoming.getChildrenWithName(child.getName());
                if (child.getMaskVar(2)) {
                    for (int k = 0; k < newChildren.size(); ++k) {
                        TreeElement newChild = child.deepCopy(true);
                        newChild.setMult(k);
                        this.children.add(i + k + 1, newChild);
                        newChild.populate(newChildren.get(k), f);
                    }
                    i += newChildren.size();
                    continue;
                }
                if (newChildren.size() == 0) {
                    child.setRelevant(false);
                    continue;
                }
                child.populate(newChildren.get(0), f);
            }
        }
        for (int i = 0; i < incoming.getAttributeCount(); ++i) {
            String name = incoming.getAttributeName(i);
            String ns = incoming.getAttributeNamespace(i);
            String value = incoming.getAttributeValue(i);
            this.setAttribute(ns, name, value);
        }
    }

    public void populateTemplate(TreeElement incoming, FormDef f) {
        if (this.isLeaf()) {
            IAnswerData value = incoming.getValue();
            if (value == null) {
                this.setValue(null);
            } else {
                Class classType = CompactInstanceWrapper.classForDataType(this.dataType);
                if (classType == null) {
                    throw new RuntimeException("data type [" + value.getClass().getName() + "] not supported inside itemset");
                }
                if (classType.isAssignableFrom(value.getClass()) && !(value instanceof SelectOneData) && !(value instanceof MultipleItemsData)) {
                    this.setValue(value);
                } else {
                    String textVal = RestoreUtils.xfFact.serializeData(value);
                    IAnswerData typedVal = RestoreUtils.xfFact.parseData(textVal, this.dataType, this.getRef(), f);
                    this.setValue(typedVal);
                }
            }
        } else {
            for (int i = 0; i < this.getNumChildren(); ++i) {
                TreeElement child = this.getChildAt(i);
                List<TreeElement> newChildren = incoming.getChildrenWithName(child.getName());
                if (child.getMaskVar(2)) {
                    for (int k = 0; k < newChildren.size(); ++k) {
                        TreeElement template = (TreeElement)f.getMainInstance().getTemplate(child.getRef());
                        TreeElement newChild = template.deepCopy(false);
                        newChild.setMult(k);
                        this.children.add(i + k + 1, newChild);
                        newChild.populateTemplate(newChildren.get(k), f);
                    }
                    i += newChildren.size();
                    continue;
                }
                child.populateTemplate(newChildren.get(0), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireReferenceCache() {
        TreeReference[] treeReferenceArray = this.refCache;
        synchronized (this.refCache) {
            this.refCache[0] = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeReference getRef() {
        TreeReference[] treeReferenceArray = this.refCache;
        synchronized (this.refCache) {
            if (this.refCache[0] == null) {
                this.refCache[0] = TreeElement.BuildRef(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.refCache[0];
        }
    }

    public static TreeReference BuildRef(AbstractTreeElement elem) {
        TreeReference ref = TreeReference.selfRef();
        while (elem != null) {
            TreeReference step;
            if (elem.getName() != null) {
                step = TreeReference.selfRef();
                step.add(elem.getName(), elem.getMult());
            } else {
                step = TreeReference.rootRef();
            }
            step.setInstanceName(elem.getInstanceName());
            if (elem.getInstanceName() != null) {
                step.setContextType(4);
            }
            ref = ref.parent(step);
            elem = elem.getParent();
        }
        return ref;
    }

    @Override
    public int getDepth() {
        return TreeElement.CalculateDepth(this);
    }

    public static int CalculateDepth(AbstractTreeElement elem) {
        int depth = 0;
        while (elem.getName() != null) {
            ++depth;
            elem = elem.getParent();
        }
        return depth;
    }

    public String getPreloadHandler() {
        return this.preloadHandler;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setPreloadHandler(String preloadHandler) {
        this.preloadHandler = preloadHandler;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public String getPreloadParams() {
        return this.preloadParams;
    }

    public void setPreloadParams(String preloadParams) {
        this.preloadParams = preloadParams;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.expireReferenceCache();
        this.name = name;
    }

    @Override
    public int getMult() {
        return this.multiplicity;
    }

    public void setMult(int multiplicity) {
        this.expireReferenceCache();
        this.multiplicity = multiplicity;
    }

    public void setParent(AbstractTreeElement parent) {
        this.expireReferenceCache();
        this.parent = parent;
    }

    @Override
    public AbstractTreeElement getParent() {
        return this.parent;
    }

    @Override
    public IAnswerData getValue() {
        return this.value;
    }

    public String toString() {
        String name = "NULL";
        if (this.name != null) {
            name = this.name;
        }
        return name + " - Children: " + Integer.toString(this.children.size());
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public boolean isRequired() {
        return this.getMaskVar(1);
    }

    public void setRepeatable(boolean repeatable) {
        this.setMaskVar(2, repeatable);
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    @Override
    public void clearCaches() {
        this.expireReferenceCache();
    }

    public void clearChildrenCaches() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            TreeElement child = this.getChildAt(i);
            child.clearCaches();
            child.clearChildrenCaches();
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public List<TreeReference> tryBatchChildFetch(String name, int mult, List<XPathExpression> predicates, EvaluationContext evalContext) {
        XPathExpression xpe;
        int i;
        if (mult != -1 || predicates == null) {
            return null;
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        ArrayList<TreeReference> selectedChildren = null;
        HashMap<XPathPathExpr, String> indices = null;
        List<TreeElement> kids = null;
        block0: for (i = 0; i < predicates.size() && (xpe = predicates.get(i)) instanceof XPathEqExpr; ++i) {
            XPathExpression left = ((XPathEqExpr)xpe).a;
            XPathExpression right = ((XPathEqExpr)xpe).b;
            if (!(left instanceof XPathPathExpr) || !(right instanceof XPathStringLiteral)) break;
            if (indices == null) {
                indices = new HashMap<XPathPathExpr, String>();
                kids = this.getChildrenWithName(name);
                if (kids.size() == 0) {
                    return null;
                }
                TreeElement kid = kids.get(0);
                for (int j = 0; j < kid.getAttributeCount(); ++j) {
                    String attribute = kid.getAttributeName(j);
                    indices.put(XPathReference.getPathExpr("@" + attribute), attribute);
                }
            }
            for (XPathPathExpr expr : indices.keySet()) {
                if (!expr.equals(left)) continue;
                String attributeName = (String)indices.get(expr);
                for (TreeElement kid : kids) {
                    if (!kid.getAttributeValue(null, attributeName).equals(((XPathStringLiteral)right).s)) continue;
                    if (selectedChildren == null) {
                        selectedChildren = new ArrayList<TreeReference>();
                    }
                    selectedChildren.add(kid.getRef());
                }
                toRemove.add(DataUtil.integer(i));
                continue block0;
            }
        }
        if (selectedChildren == null) {
            return null;
        }
        for (i = toRemove.size() - 1; i >= 0; --i) {
            predicates.remove((Integer)toRemove.get(i));
        }
        return selectedChildren;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public void populatePartial(TreeElement element) {
        if (this.isPartial) {
            this.children.clear();
            for (int i = 0; i < element.getNumChildren(); ++i) {
                this.addChild(element.getChildAt(i));
            }
            this.isPartial = false;
        }
    }
}

