/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.form.api.FormEntryCaption;
import org.javarosa.form.api.FormEntryController;
import org.javarosa.form.api.FormEntryModel;
import org.javarosa.test.ResourcePathHelper;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.util.XFormUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormParseInit {
    private static final Logger logger = LoggerFactory.getLogger(FormParseInit.class);
    private final String FORM_NAME;
    private FormDef xform;
    private FormEntryController fec;
    private FormEntryModel femodel;

    public FormParseInit() throws XFormParser.ParseException {
        this.FORM_NAME = ResourcePathHelper.r("ImageSelectTester.xhtml").toString();
        this.init();
    }

    public FormParseInit(File form) throws XFormParser.ParseException {
        this.FORM_NAME = form.getAbsolutePath();
        this.init();
    }

    private void init() throws XFormParser.ParseException {
        String xf_name = this.FORM_NAME;
        try (FileInputStream is = new FileInputStream(xf_name);){
            this.xform = XFormUtils.getFormFromInputStream(is);
        }
        catch (FileNotFoundException e) {
            logger.error("Error: the file '{}' could not be found!", (Object)xf_name);
            throw new RuntimeException("Error: the file '" + xf_name + "' could not be found!");
        }
        catch (IOException e) {
            logger.debug(String.format("Error reading form with name %s", xf_name), (Throwable)e);
            throw new RuntimeException("Error reading form with name '" + xf_name);
        }
        this.femodel = new FormEntryModel(this.xform);
        this.fec = new FormEntryController(this.femodel);
        if (this.xform == null) {
            logger.error("ERROR: XForm has failed validation!!");
        }
    }

    public QuestionDef getFirstQuestionDef() {
        this.fec.jumpToIndex(FormIndex.createBeginningOfFormIndex());
        do {
            FormEntryCaption fep;
            if (!((fep = this.femodel.getCaptionPrompt()).getFormElement() instanceof QuestionDef)) continue;
            return (QuestionDef)fep.getFormElement();
        } while (this.fec.stepToNextEvent() != 1);
        return null;
    }

    public QuestionDef getCurrentQuestion() {
        FormEntryCaption fep = this.femodel.getCaptionPrompt();
        if (fep.getFormElement() instanceof QuestionDef) {
            return (QuestionDef)fep.getFormElement();
        }
        return null;
    }

    public QuestionDef getNextQuestion() {
        if (this.fec.stepToNextEvent() == 1) {
            return null;
        }
        FormEntryCaption fep = this.getFormEntryModel().getCaptionPrompt();
        do {
            if (!(fep.getFormElement() instanceof QuestionDef)) continue;
            return (QuestionDef)fep.getFormElement();
        } while (this.fec.stepToNextEvent() != 1);
        return null;
    }

    public FormDef getFormDef() {
        return this.xform;
    }

    public FormEntryModel getFormEntryModel() {
        return this.fec.getModel();
    }

    public FormEntryController getFormEntryController() {
        return this.fec;
    }

    public String printStuff() {
        StringBuilder stuff = new StringBuilder();
        this.fec.jumpToIndex(FormIndex.createBeginningOfFormIndex());
        do {
            FormEntryCaption fep = this.femodel.getCaptionPrompt();
            boolean choiceFlag = false;
            if (fep.getFormElement() instanceof QuestionDef) {
                stuff.append("\t[Type:QuestionDef, ");
                List<SelectChoice> s = ((QuestionDef)fep.getFormElement()).getChoices();
                stuff.append("ContainsChoices: ").append(s != null && s.size() > 0 ? "true " : "false").append(", ");
                if (s != null && s.size() > 0) {
                    choiceFlag = true;
                }
            } else if (fep.getFormElement() instanceof FormDef) {
                stuff.append("\t[Type:FormDef, ");
            } else if (fep.getFormElement() instanceof GroupDef) {
                stuff.append("\t[Type:GroupDef, ");
            } else {
                stuff.append("\t[Type:Unknown]\n");
                continue;
            }
            stuff.append("ID:").append(fep.getFormElement().getID()).append(", TextID:").append(fep.getFormElement().getTextID()).append(",InnerText:").append(fep.getFormElement().getLabelInnerText());
            if (choiceFlag) {
                stuff.append("] \n\t\t---Choices:").append(((QuestionDef)fep.getFormElement()).getChoices().toString()).append("\n");
                continue;
            }
            stuff.append("]\n");
        } while (this.fec.stepToNextEvent() != 1);
        return stuff.toString();
    }
}

