/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.test;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class ResourcePathHelper {
    private static Set<File> resourcePathsCache = ResourcePathHelper.buildCache();

    private static synchronized Set<File> buildCache() {
        File root = new File(ResourcePathHelper.class.getResource("/logback-test.xml.example").getFile()).getParentFile();
        Collection files = FileUtils.listFiles((File)root, null, (boolean)true);
        return files.stream().collect(Collectors.toSet());
    }

    public static File r(String filename) {
        if (resourcePathsCache == null) {
            throw new RuntimeException("Too fast! The resources cache hasn't been built yet! Don't use r() within static members!");
        }
        return resourcePathsCache.stream().filter(f -> f.getAbsolutePath().endsWith(File.separator + filename)).findFirst().orElseThrow(() -> new RuntimeException("File " + filename + " not found among files in resources"));
    }
}

