/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.test;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.javarosa.core.model.CoreModelModule;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.ValidateOutcome;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.storage.StorageManager;
import org.javarosa.core.services.storage.util.DummyIndexedStorageUtility;
import org.javarosa.core.util.JavaRosaCoreModule;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.debug.Event;
import org.javarosa.form.api.FormEntryController;
import org.javarosa.form.api.FormEntryModel;
import org.javarosa.form.api.FormEntryPrompt;
import org.javarosa.model.xform.XFormSerializingVisitor;
import org.javarosa.model.xform.XFormsModule;
import org.javarosa.test.FormParseInit;
import org.javarosa.test.ResourcePathHelper;
import org.javarosa.test.TempFileUtils;
import org.javarosa.test.XFormsElement;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathNumNegExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scenario {
    private static final Logger log = LoggerFactory.getLogger(Scenario.class);
    public static final FormIndex BEGINNING_OF_FORM = FormIndex.createBeginningOfFormIndex();
    private final FormDef formDef;
    private FormEntryController controller;
    private EvaluationContext evaluationContext;
    private FormEntryModel model;
    private final FormInstance blankInstance;
    private final Function<FormDef, FormEntryController> controllerSupplier;

    private Scenario(FormDef formDef, Function<FormDef, FormEntryController> controllerSupplier, EvaluationContext evaluationContext, FormInstance blankInstance) {
        this.formDef = formDef;
        this.controllerSupplier = controllerSupplier;
        this.evaluationContext = evaluationContext;
        this.blankInstance = blankInstance;
    }

    private static Scenario from(FormDef formDef, boolean newInstance) {
        return Scenario.from(formDef, newInstance, formDef1 -> new FormEntryController(new FormEntryModel((FormDef)formDef1)));
    }

    private static Scenario from(FormDef formDef, boolean newInstance, Function<FormDef, FormEntryController> controllerSupplier) {
        Scenario scenario = new Scenario(formDef, controllerSupplier, formDef.getEvaluationContext(), formDef.getMainInstance().clone());
        scenario.init(newInstance);
        return scenario;
    }

    public void init(boolean newInstance) {
        this.controller = this.controllerSupplier.apply(this.formDef);
        this.model = this.controller.getModel();
        this.formDef.initialize(newInstance, new InstanceInitializationFactory());
    }

    public FormDef getFormDef() {
        return this.formDef;
    }

    public FormIndex indexOf(String xPath) {
        return this.getIndexOf(this.expandSingle(Scenario.getRef(xPath)));
    }

    public FormIndex getCurrentIndex() {
        return this.model.getFormIndex();
    }

    public ValidateOutcome getValidationOutcome() {
        return this.formDef.validate();
    }

    public static TreeReference getRef(String xpath) {
        if (xpath.trim().isEmpty()) {
            return new TreeReference();
        }
        try {
            TreeReference reference = ((XPathPathExpr)XPathParseTool.parseXPath(xpath)).getReference();
            for (int i = 0; i < reference.size(); ++i) {
                Optional<Integer> multiplicity = Scenario.extractMultiplicityFromPredicate(reference, i);
                if (!multiplicity.isPresent()) continue;
                reference.setMultiplicity(i, multiplicity.get());
                reference = reference.removePredicates(i);
            }
            return reference;
        }
        catch (XPathSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void newInstance() {
        this.formDef.setInstance(this.blankInstance.clone());
        this.init(true);
        this.evaluationContext = this.formDef.getEvaluationContext();
    }

    public void setLanguage(String language) {
        this.controller.setLanguage(language);
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public Scenario onDagEvent(Consumer<Event> callback) {
        this.formDef.setEventNotifier(callback::accept);
        return this;
    }

    public Scenario serializeAndDeserializeForm() throws IOException, DeserializationException {
        PrototypeManager.registerPrototypes(JavaRosaCoreModule.classNames);
        PrototypeManager.registerPrototypes(CoreModelModule.classNames);
        new XFormsModule().registerModule();
        File tempFile = TempFileUtils.createTempFile("javarosa", "test");
        this.formDef.writeExternal(new DataOutputStream(new FileOutputStream(tempFile)));
        FormDef deserializedFormDef = new FormDef();
        deserializedFormDef.readExternal(new DataInputStream(new FileInputStream(tempFile)), PrototypeManager.getDefault());
        tempFile.delete();
        return Scenario.from(deserializedFormDef, false);
    }

    public Scenario serializeAndDeserializeInstance(XFormsElement form) throws IOException, XFormParser.ParseException {
        FormInstance originalInstance = this.getFormDef().getMainInstance();
        XFormSerializingVisitor serializer = new XFormSerializingVisitor();
        byte[] formInstanceBytes = serializer.serializeInstance(originalInstance);
        InputStreamReader instanceReader = new InputStreamReader(new ByteArrayInputStream(formInstanceBytes));
        InputStreamReader formReader = new InputStreamReader(new ByteArrayInputStream(form.asXml().getBytes()));
        XFormParser parser = new XFormParser(formReader, instanceReader);
        FormDef restoredFormDef = parser.parse();
        return Scenario.from(restoredFormDef, false);
    }

    public TreeReference expandSingle(TreeReference reference) {
        List<TreeReference> expandedRefs = this.evaluationContext.expandReference(reference);
        if (expandedRefs.size() != 1) {
            throw new RuntimeException("Provided xPath expands to " + expandedRefs.size() + " references. Expecting exactly one expanded reference.");
        }
        return expandedRefs.get(0);
    }

    public void trace(String msg) {
        log.info("===============================================================================");
        log.info("       " + msg);
        log.info("===============================================================================");
    }

    public void finalizeInstance() {
        this.controller.finalizeFormEntry();
    }

    public FormEntryController getFormEntryController() {
        return this.controller;
    }

    private boolean refExists(TreeReference reference) {
        return this.evaluationContext.expandReference(reference).size() == 1;
    }

    private static Optional<Integer> extractMultiplicityFromPredicate(TreeReference reference, int stepNumber) {
        List<XPathExpression> predicates = reference.getPredicate(stepNumber);
        if (predicates == null || predicates.size() != 1) {
            return Optional.empty();
        }
        if (Scenario.isPositiveNumberPredicate(predicates)) {
            return Optional.ofNullable(predicates.get(0)).map(p -> ((XPathNumericLiteral)p).d - 1.0).map(Double::intValue);
        }
        if (Scenario.isNegativeNumberPredicate(predicates)) {
            return Optional.ofNullable(predicates.get(0)).map(p -> ((XPathNumNegExpr)p).a).map(p -> ((XPathNumericLiteral)p).d).map(Double::intValue).map(i -> i * -1);
        }
        if (Scenario.isAtTemplatePredicate(predicates)) {
            return Optional.of(-2);
        }
        return Optional.empty();
    }

    private static boolean isPositiveNumberPredicate(List<XPathExpression> predicates) {
        return predicates.get(0) instanceof XPathNumericLiteral;
    }

    private static boolean isNegativeNumberPredicate(List<XPathExpression> predicates) {
        return predicates.get(0) instanceof XPathNumNegExpr && ((XPathNumNegExpr)predicates.get((int)0)).a instanceof XPathNumericLiteral;
    }

    private static boolean isAtTemplatePredicate(List<XPathExpression> predicates) {
        return predicates.get(0) instanceof XPathPathExpr && ((XPathPathExpr)predicates.get((int)0)).steps.length == 1 && ((XPathPathExpr)predicates.get((int)0)).init_context == 1 && ((XPathPathExpr)predicates.get((int)0)).steps[0].axis == 8 && ((XPathPathExpr)predicates.get((int)0)).steps[0].name.name.equals("template");
    }

    private FormIndex getIndexOf(TreeReference ref) {
        TreeReference qualifiedRef = this.expandSingle(ref);
        FormIndex backupIndex = this.model.getFormIndex();
        this.silentJump(BEGINNING_OF_FORM);
        FormIndex index = this.model.getFormIndex();
        do {
            TreeReference refAtIndex;
            if ((refAtIndex = index.getReference()) == null || !refAtIndex.equals(qualifiedRef)) continue;
            this.silentJump(backupIndex);
            return index;
        } while ((index = this.model.incrementIndex(index)).isInForm());
        this.silentJump(backupIndex);
        return null;
    }

    public static Scenario init(String formName, XFormsElement form) throws IOException, XFormParser.ParseException {
        File tempDir = TempFileUtils.createTempDir("javarosa");
        File formFile = TempFileUtils.createTempFile(tempDir, formName, "xml");
        String xml = form.asXml();
        System.out.println(xml);
        FileUtils.write((File)formFile, (CharSequence)xml, (Charset)StandardCharsets.UTF_8);
        return Scenario.init(formFile);
    }

    public static Scenario init(String formName, XFormsElement form, Function<FormDef, FormEntryController> controllerSupplier) throws IOException, XFormParser.ParseException {
        File tempDir = TempFileUtils.createTempDir("javarosa");
        File formFile = TempFileUtils.createTempFile(tempDir, formName, "xml");
        String xml = form.asXml();
        System.out.println(xml);
        FileUtils.write((File)formFile, (CharSequence)xml, (Charset)StandardCharsets.UTF_8);
        return Scenario.init(formFile, controllerSupplier);
    }

    public static FormDef createFormDef(String formName, XFormsElement form) throws IOException, XFormParser.ParseException {
        File tempDir = TempFileUtils.createTempDir("javarosa");
        File formFile = TempFileUtils.createTempFile(tempDir, formName, "xml");
        String xml = form.asXml();
        System.out.println(xml);
        FileUtils.write((File)formFile, (CharSequence)xml, (Charset)StandardCharsets.UTF_8);
        return Scenario.createFormDef(formFile);
    }

    public static Scenario init(String formFileName) throws XFormParser.ParseException {
        return Scenario.init(ResourcePathHelper.r(formFileName));
    }

    public static Scenario init(File formFile) throws XFormParser.ParseException {
        FormDef formDef = Scenario.createFormDef(formFile);
        return Scenario.from(formDef, true);
    }

    private static Scenario init(File formFile, Function<FormDef, FormEntryController> controllerSupplier) throws XFormParser.ParseException {
        FormDef formDef = Scenario.createFormDef(formFile);
        return Scenario.from(formDef, true, controllerSupplier);
    }

    public static Scenario init(FormDef formDef) throws XFormParser.ParseException {
        return Scenario.from(formDef, true);
    }

    @NotNull
    public static FormDef createFormDef(File formFile) throws XFormParser.ParseException {
        StorageManager.setStorageFactory((name, type) -> new DummyIndexedStorageUtility());
        new XFormsModule().registerModule();
        FormParseInit fpi = new FormParseInit(formFile);
        FormDef formDef = fpi.getFormDef();
        return formDef;
    }

    public AnswerResult answer(String xPath, String value) {
        this.createMissingRepeats(xPath);
        TreeReference ref = Scenario.getRef(xPath);
        this.silentJump(this.getIndexOf(ref));
        return this.answer(value);
    }

    public AnswerResult answer(String xPath, String ... selectionValues) {
        this.createMissingRepeats(xPath);
        TreeReference ref = Scenario.getRef(xPath);
        this.silentJump(this.getIndexOf(ref));
        return this.answer(Arrays.asList(selectionValues));
    }

    public AnswerResult answer(String xPath, int value) {
        this.createMissingRepeats(xPath);
        TreeReference ref = Scenario.getRef(xPath);
        this.silentJump(this.getIndexOf(ref));
        return this.answer(value);
    }

    public AnswerResult answer(String xPath, double value) {
        this.createMissingRepeats(xPath);
        TreeReference ref = Scenario.getRef(xPath);
        this.silentJump(this.getIndexOf(ref));
        return this.answer(value);
    }

    public AnswerResult answer(String xPath, boolean value) {
        this.createMissingRepeats(xPath);
        TreeReference ref = Scenario.getRef(xPath);
        this.silentJump(this.getIndexOf(ref));
        return this.answer(value);
    }

    public AnswerResult answer(String value) {
        return this.answer(new StringData(value));
    }

    public AnswerResult answer(List<String> values) {
        return this.answer(new MultipleItemsData(values.stream().map(Selection::new).collect(Collectors.toList())));
    }

    public AnswerResult answer(SelectChoice choice) {
        return this.answer(new SelectOneData(choice.selection()));
    }

    public AnswerResult answer(int value) {
        return this.answer(new IntegerData(value));
    }

    public AnswerResult answer(double value) {
        return this.answer(new DecimalData(value));
    }

    public AnswerResult answer(char value) {
        return this.answer(new StringData(String.valueOf(value)));
    }

    public AnswerResult answer(LocalDate value) {
        return this.answer(new DateData(Date.from(value.atStartOfDay(ZoneId.of("UTC")).toInstant())));
    }

    public AnswerResult answer(boolean value) {
        return this.answer(new BooleanData(value));
    }

    private AnswerResult answer(IAnswerData data) {
        FormIndex formIndex = this.model.getFormIndex();
        log.info("Answer {} at {}", (Object)data, (Object)formIndex.getReference().toString(true, true));
        return AnswerResult.from(this.controller.answerQuestion(formIndex, data, true));
    }

    public Scenario removeRepeat(String xPath) {
        TreeReference reference = this.expandSingle(Scenario.getRef(xPath));
        TreeElement group = (TreeElement)this.formDef.getMainInstance().resolveReference(reference);
        FormIndex childIndex = null;
        for (int i = 0; i < group.getNumChildren() && (childIndex = this.getIndexOf(group.getChildAt(i).getRef())) == null; ++i) {
        }
        if (childIndex == null) {
            throw new RuntimeException("Can't find an index inside the repeat group you want to remove. Please add some field and a form control.");
        }
        this.formDef.deleteRepeat(childIndex);
        return this;
    }

    public Scenario createNewRepeat() {
        log.info("Create repeat instance {}", (Object)this.model.getFormIndex().getReference());
        this.controller.newRepeat();
        return this;
    }

    public Scenario createNewRepeat(String xPath) {
        TreeReference groupRef = Scenario.getRef(xPath);
        if (!groupRef.isAmbiguous()) {
            throw new RuntimeException("Provided xPath must be ambiguous");
        }
        TreeReference repeatInstanceRef = groupRef.clone();
        int multiplicity = this.evaluationContext.expandReference(repeatInstanceRef).size();
        repeatInstanceRef.setMultiplicity(repeatInstanceRef.size() - 1, multiplicity);
        return this.createRepeat(repeatInstanceRef);
    }

    private Scenario createRepeat(TreeReference repeatInstanceRef) {
        if (repeatInstanceRef.isAmbiguous()) {
            throw new RuntimeException("The provided reference can't be ambiguous");
        }
        this.silentJump(BEGINNING_OF_FORM);
        while (!this.atTheEndOfForm() && !this.refExists(repeatInstanceRef)) {
            if (this.silentNext() != 2 || !this.model.getFormIndex().getReference().equals(repeatInstanceRef)) continue;
            while (!this.refExists(repeatInstanceRef)) {
                this.controller.descendIntoNewRepeat();
            }
        }
        if (!this.refExists(repeatInstanceRef)) {
            throw new RuntimeException("We couldn't create repeat group instance at " + repeatInstanceRef + ". Check your form and your test");
        }
        return this;
    }

    private void createMissingRepeats(String xPath) {
        FormIndex backupIndex = this.model.getFormIndex();
        TreeReference reference = Scenario.getRef(xPath);
        for (int i = 0; i < reference.size(); ++i) {
            if (reference.getMultiplicity(i) < 0) continue;
            this.createRepeat(reference.getSubReference(i));
        }
        this.silentJump(backupIndex);
    }

    public int next() {
        int jumpResultCode = this.controller.stepToNextEvent();
        log.info(this.humanJumpTrace(jumpResultCode));
        return jumpResultCode;
    }

    public int prev() {
        int jumpResultCode = this.controller.stepToPreviousEvent();
        log.info(this.humanJumpTrace(jumpResultCode));
        return jumpResultCode;
    }

    public void next(int amount) {
        while (amount-- > 0) {
            this.next();
        }
    }

    public void jumpToBeginningOfForm() {
        this.jump(BEGINNING_OF_FORM);
    }

    private int silentNext() {
        return this.controller.stepToNextEvent();
    }

    private int silentPrev() {
        return this.controller.stepToPreviousEvent();
    }

    private int jump(FormIndex index) {
        int jumpResultCode = this.controller.jumpToIndex(index);
        log.info(this.humanJumpTrace(jumpResultCode));
        return jumpResultCode;
    }

    private void silentJump(FormIndex indexOf) {
        this.controller.jumpToIndex(indexOf);
    }

    private String humanJumpTrace(int jumpResultCode) {
        FormIndex formIndex = this.model.getFormIndex();
        String humanJumpResult = this.decodeJumpResult(jumpResultCode);
        IFormElement element = this.formDef.getChild(formIndex);
        String humanLabel = Optional.ofNullable(element.getLabelInnerText()).orElseGet(() -> {
            Localizer localizer = this.formDef.getLocalizer();
            String textId = element.getTextID();
            if (textId == null || localizer == null) {
                return "";
            }
            return Optional.ofNullable(localizer.getText(textId)).map(this::trimToOneLine).orElse("");
        });
        String humanReference = Optional.ofNullable(formIndex.getReference()).map(ref -> ref.toString(true, true)).orElse("");
        return String.format("Jump to %s%s%s", humanJumpResult, this.prefixIfNotEmpty(" ", humanLabel), this.prefixIfNotEmpty(" ref:", humanReference));
    }

    private String prefixIfNotEmpty(String prefix, String text) {
        return text.isEmpty() ? "" : prefix + text;
    }

    private String trimToOneLine(String text) {
        return Stream.of(text.split("\n")).map(String::trim).collect(Collectors.joining(" "));
    }

    private String decodeJumpResult(int code) {
        switch (code) {
            case 0: {
                return "Beginning of Form";
            }
            case 1: {
                return "End of Form";
            }
            case 2: {
                return "Prompt new Repeat";
            }
            case 4: {
                return "Question";
            }
            case 8: {
                return "Group";
            }
            case 16: {
                return "Repeat";
            }
            case 32: {
                return "Repeat Juncture";
            }
        }
        return "Unknown";
    }

    public boolean atTheEndOfForm() {
        return this.model.getFormIndex().isEndOfFormIndex();
    }

    public TreeReference nextRef() {
        this.silentNext();
        TreeReference ref = this.refAtIndex();
        this.silentPrev();
        return ref;
    }

    public TreeReference refAtIndex() {
        return this.controller.getModel().getFormIndex().getReference();
    }

    public boolean atQuestion() {
        return this.formDef.getChild(this.controller.getModel().getFormIndex()) instanceof QuestionDef;
    }

    public QuestionDef getQuestionAtIndex() {
        return this.model.getQuestionPrompt().getQuestion();
    }

    public FormEntryPrompt getFormEntryPromptAtIndex() {
        return this.model.getQuestionPrompt();
    }

    public <T extends IAnswerData> T answerOf(String xPath) {
        TreeReference reference = Scenario.getRef(xPath);
        if (!this.refExists(reference)) {
            return null;
        }
        TreeElement element = (TreeElement)this.formDef.getMainInstance().resolveReference(reference);
        return (T)(element != null ? element.getValue() : null);
    }

    public int countRepeatInstancesOf(String xPath) {
        TreeReference reference = Scenario.getRef(xPath);
        if (!reference.isAmbiguous()) {
            throw new RuntimeException("Provided xPath must be ambiguous");
        }
        List<TreeReference> treeReferences = this.evaluationContext.expandReference(reference);
        return treeReferences.size();
    }

    public List<SelectChoice> choicesOf(String xPath) {
        TreeReference reference = this.expandSingle(Scenario.getRef(xPath));
        FormEntryPrompt questionPrompt = this.model.getQuestionPrompt(this.getIndexOf(reference));
        QuestionDef control = questionPrompt.getQuestion();
        return control.getChoices() == null ? control.getDynamicChoices().getChoices(this.formDef, reference) : control.getChoices();
    }

    public TreeElement getAnswerNode(String xPath) {
        return (TreeElement)this.formDef.getMainInstance().resolveReference(this.expandSingle(Scenario.getRef(xPath)));
    }

    public static enum AnswerResult {
        OK(0),
        REQUIRED_BUT_EMPTY(1),
        CONSTRAINT_VIOLATED(2);

        private final int jrCode;

        private AnswerResult(int jrCode) {
            this.jrCode = jrCode;
        }

        public static AnswerResult from(int jrCode) {
            return Stream.of(AnswerResult.values()).filter(v -> v.jrCode == jrCode).findFirst().orElseThrow(RuntimeException::new);
        }
    }
}

