/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.javarosa.test.EmptyXFormsElement;
import org.javarosa.test.StringLiteralXFormsElement;
import org.javarosa.test.TagXFormsElement;

public interface XFormsElement {
    public static String buildAttributesString(Map<String, String> attributes) {
        StringBuilder attributesStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesStringBuilder.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"").append(" ");
        }
        return attributesStringBuilder.toString().trim();
    }

    public String getName();

    public String asXml();

    public static Map<String, String> parseAttributes(String name) {
        if (!name.contains(" ")) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        String SPACE_OUTSIDE_QUOTES_REGEX = " (?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
        Pattern spaceOutsideQuotesPattern = Pattern.compile(" (?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
        String[] words = spaceOutsideQuotesPattern.split(name);
        for (String word : Arrays.asList(words).subList(1, words.length)) {
            String[] parts = word.split("(?<!\\))=(\"|')", 2);
            attributes.put(parts[0], parts[1].substring(0, parts[1].length() - 1));
        }
        return attributes;
    }

    public static String parseName(String name) {
        if (!name.contains(" ")) {
            return name;
        }
        return name.split(" ")[0];
    }

    public static XFormsElement t(String name, XFormsElement ... children) {
        if (children.length == 0) {
            return new EmptyXFormsElement(XFormsElement.parseName(name), XFormsElement.parseAttributes(name));
        }
        return new TagXFormsElement(XFormsElement.parseName(name), XFormsElement.parseAttributes(name), Arrays.asList(children));
    }

    public static XFormsElement t(String name, String innerHtml) {
        return new StringLiteralXFormsElement(XFormsElement.parseName(name), XFormsElement.parseAttributes(name), innerHtml);
    }

    public static XFormsElement html(HeadXFormsElement head, BodyXFormsElement body) {
        return XFormsElement.t("h:html xmlns=\"http://www.w3.org/2002/xforms\" xmlns:h=\"http://www.w3.org/1999/xhtml\" xmlns:jr=\"http://openrosa.org/javarosa\" xmlns:odk=\"http://www.opendatakit.org/xforms\" xmlns:orx=\"http://openrosa.org/xforms\"", head, body);
    }

    public static XFormsElement html(List<Pair<String, String>> additionalNamespaces, HeadXFormsElement head, BodyXFormsElement body) {
        String additionalNamespacesString = additionalNamespaces.stream().map(namespace -> "xmlns:" + (String)namespace.getFirst() + "=\"" + (String)namespace.getSecond() + "\" ").collect(Collectors.joining());
        return XFormsElement.t("h:html xmlns=\"http://www.w3.org/2002/xforms\" xmlns:h=\"http://www.w3.org/1999/xhtml\" xmlns:jr=\"http://openrosa.org/javarosa\" xmlns:odk=\"http://www.opendatakit.org/xforms\" xmlns:orx=\"http://openrosa.org/xforms\" " + additionalNamespacesString, head, body);
    }

    public static HeadXFormsElement head(XFormsElement ... children) {
        return new HeadXFormsElement(children);
    }

    public static BodyXFormsElement body(XFormsElement ... children) {
        return new BodyXFormsElement(children);
    }

    public static XFormsElement title(String innerHTML) {
        return XFormsElement.t("h:title", innerHTML);
    }

    public static XFormsElement model(XFormsElement ... children) {
        return XFormsElement.t("model", children);
    }

    public static XFormsElement model(List<Pair<String, String>> attributes, XFormsElement ... children) {
        StringBuilder stringBuilder = new StringBuilder();
        attributes.stream().forEach(attribute -> stringBuilder.append(" " + (String)attribute.getFirst() + "=\"" + (String)attribute.getSecond() + "\""));
        return XFormsElement.t("model" + stringBuilder, children);
    }

    public static XFormsElement mainInstance(XFormsElement ... children) {
        return XFormsElement.t("instance", children);
    }

    public static XFormsElement instance(String name, XFormsElement ... children) {
        return XFormsElement.t("instance id=\"" + name + "\"", XFormsElement.t("root", children));
    }

    public static XFormsElement input(String ref, XFormsElement ... children) {
        return XFormsElement.t("input ref=\"" + ref + "\"", children);
    }

    public static XFormsElement select1(String ref, XFormsElement ... children) {
        return XFormsElement.t("select1 ref=\"" + ref + "\"", children);
    }

    public static XFormsElement select1Dynamic(String ref, String nodesetRef) {
        return XFormsElement.select1Dynamic(ref, nodesetRef, "value", "label");
    }

    public static XFormsElement select1Dynamic(String ref, String nodesetRef, String valueRef, String labelRef) {
        return XFormsElement.t("select1 ref=\"" + ref + "\"", XFormsElement.t("itemset nodeset=\"" + nodesetRef + "\"", XFormsElement.t("value ref=\"" + valueRef + "\"", new XFormsElement[0]), XFormsElement.t("label ref=\"" + labelRef + "\"", new XFormsElement[0])));
    }

    public static XFormsElement group(String ref, XFormsElement ... children) {
        return XFormsElement.t("group ref=\"" + ref + "\"", children);
    }

    public static XFormsElement repeat(String ref, XFormsElement ... children) {
        return XFormsElement.t("repeat nodeset=\"" + ref + "\"", children);
    }

    public static XFormsElement repeat(String ref, String countRef, XFormsElement ... children) {
        return XFormsElement.t("repeat nodeset=\"" + ref + "\" jr:count=\"" + countRef + "\"", children);
    }

    public static XFormsElement label(String innerHtml) {
        return new StringLiteralXFormsElement("label", Collections.emptyMap(), innerHtml);
    }

    public static XFormsElement item(int value, String label) {
        return XFormsElement.item(String.valueOf(value), label);
    }

    public static XFormsElement item(String value, String label) {
        return XFormsElement.t("item", XFormsElement.t("label", label), XFormsElement.t("value", value));
    }

    public static XFormsElement setvalue(String event, String ref, String value) {
        return XFormsElement.t("setvalue event=\"" + event + "\" ref=\"" + ref + "\" value=\"" + value + "\"", new XFormsElement[0]);
    }

    public static XFormsElement setvalue(String event, String ref) {
        return XFormsElement.t("setvalue event=\"" + event + "\" ref=\"" + ref + "\"", new XFormsElement[0]);
    }

    public static XFormsElement setvalueLiteral(String event, String ref, String innerHtml) {
        return XFormsElement.t("setvalue event=\"" + event + "\" ref=\"" + ref + "\"", innerHtml);
    }

    public static class BodyXFormsElement
    extends TagXFormsElement {
        public BodyXFormsElement(XFormsElement[] children) {
            super("h:body", Collections.emptyMap(), Arrays.asList(children));
        }
    }

    public static class HeadXFormsElement
    extends TagXFormsElement {
        public HeadXFormsElement(XFormsElement[] children) {
            super("h:head", Collections.emptyMap(), Arrays.asList(children));
        }
    }
}

