/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.io.DataInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.xform.parse.ExternalInstanceParser;
import org.javarosa.xform.parse.ExternalInstanceParserFactory;
import org.javarosa.xform.parse.IXFormParserFactory;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.parse.XFormParserFactory;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.kxml2.kdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class XFormUtils {
    private static final Logger logger = LoggerFactory.getLogger(XFormUtils.class);
    private static IXFormParserFactory _factory = new XFormParserFactory();
    private static ExternalInstanceParserFactory externalInstanceParserFactory = ExternalInstanceParser::new;

    public static IXFormParserFactory setXFormParserFactory(IXFormParserFactory factory) {
        IXFormParserFactory oldFactory = _factory;
        _factory = factory;
        return oldFactory;
    }

    public static void setExternalInstanceParserFactory(ExternalInstanceParserFactory factory) {
        externalInstanceParserFactory = factory;
    }

    public static FormDef getFormFromResource(String resource) throws XFormParser.ParseException {
        InputStream is = System.class.getResourceAsStream(resource);
        if (is == null) {
            logger.error("Can't find form resource {}. Is it in the JAR?", (Object)resource);
            return null;
        }
        return XFormUtils.getFormFromInputStream(is);
    }

    public static FormDef getFormRaw(InputStreamReader isr) throws XFormParseException, IOException, XFormParser.ParseException {
        return _factory.getXFormParser(isr).parse();
    }

    public static FormDef getFormFromInputStream(InputStream is) throws XFormParseException, XFormParser.ParseException {
        return XFormUtils.getFormFromInputStream(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormDef getFormFromInputStream(InputStream is, String lastSavedSrc) throws XFormParser.ParseException {
        InputStreamReader isr = null;
        try {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new XFormParseException("IO Exception during parse! " + uee.getMessage());
            }
            XFormParser xFormParser = _factory.getXFormParser(isr);
            FormDef formDef = xFormParser.parse(lastSavedSrc);
            return formDef;
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                logger.error("IO Exception while closing stream.", (Throwable)e);
            }
        }
    }

    public static FormDef getFormFromFormXml(String formXmlSrc, String lastSavedSrc) throws XFormParseException, XFormParser.ParseException {
        FileReader isr = null;
        try {
            isr = new FileReader(formXmlSrc);
            XFormParser xFormParser = _factory.getXFormParser(isr);
            FormDef formDef = xFormParser.parse(formXmlSrc, lastSavedSrc);
            return formDef;
        }
        catch (IOException e) {
            throw new XFormParseException("IO Exception during parse! " + e.getMessage());
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                logger.error("IO Exception while closing stream.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormDef getFormFromSerializedResource(String resource) {
        FormDef returnForm = null;
        InputStream is = System.class.getResourceAsStream(resource);
        DataInputStream dis = null;
        try {
            if (is != null) {
                dis = new DataInputStream(is);
                returnForm = (FormDef)ExtUtil.read(dis, FormDef.class);
            } else {
                logger.info("ResourceStream NULL");
            }
        }
        catch (IOException e) {
            logger.error("Error", (Throwable)e);
        }
        catch (DeserializationException e) {
            logger.error("Error", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("Error", (Throwable)e);
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    logger.error("Error", (Throwable)e);
                }
            }
        }
        return returnForm;
    }

    public static TreeElement getExternalInstance(ReferenceManager referenceManager, String id, String instanceSrc, boolean partial) throws UnfullfilledRequirementsException, InvalidStructureException, XmlPullParserException, IOException, InvalidReferenceException {
        return externalInstanceParserFactory.getExternalInstanceParser().parse(referenceManager, id, instanceSrc, partial);
    }

    public static TreeElement getExternalInstance(ReferenceManager referenceManager, String id, String instanceSrc) throws UnfullfilledRequirementsException, InvalidStructureException, XmlPullParserException, IOException, InvalidReferenceException {
        return XFormUtils.getExternalInstance(referenceManager, id, instanceSrc, false);
    }

    public static List<String> getAttributeList(Element e) {
        ArrayList<String> atts = new ArrayList<String>(e.getAttributeCount());
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            atts.add(e.getAttributeName(i));
        }
        return atts;
    }

    public static List<String> getUnusedAttributes(Element e, List<String> usedAtts) {
        List<String> unusedAtts = XFormUtils.getAttributeList(e);
        for (int i = 0; i < usedAtts.size(); ++i) {
            if (!unusedAtts.contains(usedAtts.get(i))) continue;
            unusedAtts.remove(usedAtts.get(i));
        }
        return unusedAtts;
    }

    public static String unusedAttWarning(Element e, List<String> usedAtts) {
        String warning = "Warning: ";
        List<String> unusedAttributes = XFormUtils.getUnusedAttributes(e, usedAtts);
        warning = warning + unusedAttributes.size() + " Unrecognized attributes found in Element [" + e.getName() + "] and will be ignored: ";
        warning = warning + "[";
        for (int i = 0; i < unusedAttributes.size(); ++i) {
            warning = warning + unusedAttributes.get(i);
            if (i == unusedAttributes.size() - 1) continue;
            warning = warning + ",";
        }
        warning = warning + "] ";
        return warning;
    }

    public static boolean showUnusedAttributeWarning(Element e, List<String> usedAtts) {
        return XFormUtils.getUnusedAttributes(e, usedAtts).size() > 0;
    }

    public static boolean isOutput(Element e) {
        return e.getName().toLowerCase().equals("output");
    }
}

