/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import org.javarosa.core.util.Base64;
import org.javarosa.xpath.XPathUnsupportedException;

enum Encoding {
    HEX("hex"){

        @Override
        String encode(byte[] bytes) {
            StringBuilder sb = new StringBuilder(bytes.length * 2);
            for (byte b : bytes) {
                sb.append(HEX_TBL[b >> 4 & 0xF]);
                sb.append(HEX_TBL[b & 0xF]);
            }
            return sb.toString();
        }

        @Override
        byte[] decode(byte[] bytes) {
            int len = bytes.length;
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(bytes[i], 16) << 4) + Character.digit(bytes[i + 1], 16));
            }
            return data;
        }
    }
    ,
    BASE64("base64"){

        @Override
        String encode(byte[] sArr) {
            return Base64.encode(sArr);
        }

        @Override
        byte[] decode(byte[] sArr) {
            return Base64.decode(sArr);
        }
    };

    private final String name;
    private static final char[] HEX_TBL;

    private Encoding(String name) {
        this.name = name;
    }

    static Encoding from(String name) {
        try {
            return Encoding.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new XPathUnsupportedException("digest(..., ..., '" + name + "')");
        }
    }

    abstract String encode(byte[] var1);

    abstract byte[] decode(byte[] var1);

    static {
        HEX_TBL = "0123456789abcdef".toCharArray();
    }
}

