/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.xpath.expr.XPathArithExpr;
import org.javarosa.xpath.expr.XPathBoolExpr;
import org.javarosa.xpath.expr.XPathCmpExpr;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathFilterExpr;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathNumNegExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStep;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.javarosa.xpath.expr.XPathUnionExpr;
import org.javarosa.xpath.expr.XPathVariableReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XPathExpression
implements Externalizable,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(XPathExpression.class);
    int indent;

    public Object eval(EvaluationContext evalContext) {
        return this.eval(evalContext.getMainInstance(), evalContext);
    }

    public abstract Object eval(DataInstance var1, EvaluationContext var2);

    public final List<Object> pivot(DataInstance model, EvaluationContext evalContext) throws UnpivotableExpressionException {
        try {
            ArrayList<Object> pivots = new ArrayList<Object>();
            this.pivot(model, evalContext, pivots, evalContext.getContextRef());
            return pivots;
        }
        catch (UnpivotableExpressionException uee) {
            throw uee;
        }
        catch (Exception e) {
            logger.error("Error while pivoting", (Throwable)e);
            throw new UnpivotableExpressionException(e.getMessage());
        }
    }

    public Object pivot(DataInstance model, EvaluationContext evalContext, List<Object> pivots, Object sentinal) throws UnpivotableExpressionException {
        return this.eval(model, evalContext);
    }

    private void printStr(String s) {
        StringBuilder padding = new StringBuilder();
        for (int i = 0; i < 2 * this.indent; ++i) {
            padding.append(" ");
        }
        logger.info("{}{}", (Object)padding, (Object)s);
    }

    public void printParseTree() {
        this.indent = -1;
        this.print(this);
    }

    public void print(Object o) {
        ++this.indent;
        if (o instanceof XPathStringLiteral) {
            XPathStringLiteral x = (XPathStringLiteral)o;
            this.printStr("strlit {" + x.s + "}");
        } else if (o instanceof XPathNumericLiteral) {
            XPathNumericLiteral x = (XPathNumericLiteral)o;
            this.printStr("numlit {" + x.d + "}");
        } else if (o instanceof XPathVariableReference) {
            XPathVariableReference x = (XPathVariableReference)o;
            this.printStr("var {" + x.id.toString() + "}");
        } else if (o instanceof XPathArithExpr) {
            XPathArithExpr x = (XPathArithExpr)o;
            String op = null;
            switch (x.op) {
                case 0: {
                    op = "add";
                    break;
                }
                case 1: {
                    op = "subtr";
                    break;
                }
                case 2: {
                    op = "mult";
                    break;
                }
                case 3: {
                    op = "div";
                    break;
                }
                case 4: {
                    op = "mod";
                }
            }
            this.printStr(op + " {{");
            this.print(x.a);
            this.printStr(" } {");
            this.print(x.b);
            this.printStr("}}");
        } else if (o instanceof XPathBoolExpr) {
            XPathBoolExpr x = (XPathBoolExpr)o;
            String op = null;
            switch (x.op) {
                case 0: {
                    op = "and";
                    break;
                }
                case 1: {
                    op = "or";
                }
            }
            this.printStr(op + " {{");
            this.print(x.a);
            this.printStr(" } {");
            this.print(x.b);
            this.printStr("}}");
        } else if (o instanceof XPathCmpExpr) {
            XPathCmpExpr x = (XPathCmpExpr)o;
            String op = null;
            switch (x.op) {
                case 0: {
                    op = "lt";
                    break;
                }
                case 2: {
                    op = "lte";
                    break;
                }
                case 1: {
                    op = "gt";
                    break;
                }
                case 3: {
                    op = "gte";
                }
            }
            this.printStr(op + " {{");
            this.print(x.a);
            this.printStr(" } {");
            this.print(x.b);
            this.printStr("}}");
        } else if (o instanceof XPathEqExpr) {
            XPathEqExpr x = (XPathEqExpr)o;
            String op = x.equal ? "eq" : "neq";
            this.printStr(op + " {{");
            this.print(x.a);
            this.printStr(" } {");
            this.print(x.b);
            this.printStr("}}");
        } else if (o instanceof XPathUnionExpr) {
            XPathUnionExpr x = (XPathUnionExpr)o;
            this.printStr("union {{");
            this.print(x.a);
            this.printStr(" } {");
            this.print(x.b);
            this.printStr("}}");
        } else if (o instanceof XPathNumNegExpr) {
            XPathNumNegExpr x = (XPathNumNegExpr)o;
            this.printStr("neg {");
            this.print(x.a);
            this.printStr("}");
        } else if (o instanceof XPathFuncExpr) {
            XPathFuncExpr x = (XPathFuncExpr)o;
            if (x.args.length == 0) {
                this.printStr("func {" + x.id.toString() + ", args {none}}");
            } else {
                this.printStr("func {" + x.id.toString() + ", args {{");
                for (int i = 0; i < x.args.length; ++i) {
                    this.print(x.args[i]);
                    if (i >= x.args.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        } else if (o instanceof XPathPathExpr) {
            XPathPathExpr x = (XPathPathExpr)o;
            String init = null;
            switch (x.init_context) {
                case 0: {
                    init = "root";
                    break;
                }
                case 1: {
                    init = "relative";
                    break;
                }
                case 2: {
                    init = "expr";
                }
            }
            this.printStr("path {init-context:" + init + ",");
            if (x.init_context == 2) {
                this.printStr(" init-expr:{");
                this.print(x.filtExpr);
                this.printStr(" }");
            }
            if (x.steps.length == 0) {
                this.printStr(" steps {none}");
                this.printStr("}");
            } else {
                this.printStr(" steps {{");
                for (int i = 0; i < x.steps.length; ++i) {
                    this.print(x.steps[i]);
                    if (i >= x.steps.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        } else if (o instanceof XPathFilterExpr) {
            XPathFilterExpr x = (XPathFilterExpr)o;
            this.printStr("filter-expr:{{");
            this.print(x.x);
            if (x.predicates.length == 0) {
                this.printStr(" } predicates {none}}");
            } else {
                this.printStr(" } predicates {{");
                for (int i = 0; i < x.predicates.length; ++i) {
                    this.print(x.predicates[i]);
                    if (i >= x.predicates.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr(" }}}");
            }
        } else if (o instanceof XPathStep) {
            XPathStep x = (XPathStep)o;
            String axis = null;
            String test = null;
            axis = XPathStep.axisStr(x.axis);
            test = x.testStr();
            if (x.predicates.length == 0) {
                this.printStr("step {axis:" + axis + " test:" + test + " predicates {none}}");
            } else {
                this.printStr("step {axis:" + axis + " test:" + test + " predicates {{");
                for (int i = 0; i < x.predicates.length; ++i) {
                    this.print(x.predicates[i]);
                    if (i >= x.predicates.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        }
        --this.indent;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract boolean isIdempotent();

    public abstract boolean containsFunc(@NotNull String var1);
}

