/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.rewriter.service;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.ejb.Asynchronous;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.giavacms.base.model.Page;
import org.giavacms.base.repository.PageRepository;
import org.giavacms.common.model.Search;
import org.giavacms.rewriter.service.FileSystemWriterService;
import org.jboss.logging.Logger;

@Stateless
@LocalBean
public class CacheService
implements Serializable {
    private static final long serialVersionUID = 1L;
    Logger logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    @Inject
    FileSystemWriterService fileSystemWriterService;
    @Inject
    PageRepository pageRepository;

    public void cacheByPageId(String pageId) {
        this.write(pageId);
    }

    public void cacheByTemplateId(Long id) {
        this.writeByTemplate(id);
    }

    @Asynchronous
    public void cacheByTemplateImplId(Long id) {
        this.writeByTemplateImpl(id);
    }

    public String write(String pageId) {
        try {
            StringBuffer sb = new StringBuffer();
            Page page = this.pageRepository.fetch((Object)pageId);
            boolean overwrite = true;
            List<String> files = this.fileSystemWriterService.write(this.getAbsolutePath(), page, overwrite);
            for (String file : files) {
                sb.append(", ").append(file);
            }
            return "Written: " + (sb.length() == 0 ? "none" : sb.substring(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getCanonicalName() + ": " + e.getMessage();
        }
    }

    public String writeAll() {
        Search sp = new Search(Page.class);
        ((Page)sp.getObj()).setExtended(true);
        ((Page)sp.getObj()).setClone(true);
        return this.writeAllWithSearch(null, (Search<Page>)sp, true);
    }

    public String writeByTemplate(Long id) {
        Search sp = new Search(Page.class);
        ((Page)sp.getObj()).getTemplate().getTemplate().setId(id);
        ((Page)sp.getObj()).setExtended(true);
        ((Page)sp.getObj()).setClone(true);
        return this.writeAllWithSearch(null, (Search<Page>)sp, true);
    }

    public String writeByTemplateImpl(Long id) {
        Search sp = new Search(Page.class);
        ((Page)sp.getObj()).getTemplate().setId(id);
        ((Page)sp.getObj()).setExtended(true);
        ((Page)sp.getObj()).setClone(true);
        return this.writeAllWithSearch(null, (Search<Page>)sp, true);
    }

    private String writeAllWithSearch(String path, Search<Page> search, boolean overwrite) {
        try {
            StringBuffer sb = new StringBuffer();
            int pages = this.pageRepository.getListSize(search);
            int pagesPerIteration = 10;
            for (int i = 0; i < pages; i += pagesPerIteration) {
                for (Page page : this.pageRepository.getList(search, i, pagesPerIteration)) {
                    List<String> files = this.fileSystemWriterService.write(this.getAbsolutePath(path), page, overwrite);
                    for (String file : files) {
                        sb.append(", ").append(file);
                    }
                }
                sb.append("---------------------------------------");
            }
            return "Written: " + (sb.length() == 0 ? "none" : sb.substring(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getCanonicalName() + ": " + e.getMessage();
        }
    }

    public String clear(String page) {
        try {
            return this.fileSystemWriterService.clear(this.getAbsolutePath(), page);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getCanonicalName() + ": " + e.getMessage();
        }
    }

    public String clearAll() {
        try {
            return this.fileSystemWriterService.clearAll(this.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getCanonicalName() + ": " + e.getMessage();
        }
    }

    public String clearByTemplateId(Long id) {
        try {
            return "TODO";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getCanonicalName() + ": " + e.getMessage();
        }
    }

    @Asynchronous
    public void writeAll(String path) {
        Search sp = new Search(Page.class);
        ((Page)sp.getObj()).setExtended(true);
        ((Page)sp.getObj()).setClone(true);
        this.writeAllWithSearch(path, (Search<Page>)sp, true);
    }

    private File getAbsolutePath() throws Exception {
        return this.getAbsolutePath(null);
    }

    private File getAbsolutePath(String path) throws Exception {
        File absolutePath = null;
        if (path == null || path.trim().length() == 0) {
            String realPath = this.getClass().getClassLoader().getResource("cache.marker").getPath();
            this.logger.info((Object)("NO PATH - USO REAL PATH: " + realPath));
            ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            absolutePath = new File(realPath.substring(0, realPath.indexOf("WEB-INF")), servletContext.getInitParameter("pagesPath"));
            this.logger.info((Object)("absolutePath: " + absolutePath));
        } else {
            this.logger.info((Object)("USO PATH: " + path));
            String realPath = this.getClass().getClassLoader().getResource("cache.marker").getPath();
            absolutePath = new File(realPath.substring(0, realPath.indexOf("WEB-INF")), path.replace("/", ""));
        }
        if (!absolutePath.exists()) {
            if (absolutePath.mkdir()) {
                return absolutePath;
            }
            throw new Exception("Failed to make dir: " + path);
        }
        if (!absolutePath.isDirectory()) {
            throw new Exception("Invalid dir: " + path);
        }
        return absolutePath;
    }

    public void cacheByPageIdAndTemplateId(String pageId, boolean clone, Long templateId) {
        this.cacheByPageId(pageId);
        if (!clone) {
            this.cacheByTemplateImplId(templateId);
        }
    }
}

