/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.FileUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Center;
import org.giavacms.exhibition.model.Institute;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.CenterRepository;

@Named
@SessionScoped
public class CenterController
extends AbstractLazyController<Center> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/center/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/center/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/center/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/center/edit-image.xhtml";
    @Inject
    @OwnRepository(value=CenterRepository.class)
    CenterRepository centerRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Center t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Institute.class);
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Institute.class);
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.resetItemsForClass(Institute.class);
        return this.listPage();
    }

    public String deleteImg() {
        ((Center)this.getElement()).setImage(null);
        this.centerRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Center)this.getElement()).getNewImage().getUploadedData() != null && ((Center)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Center)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Center)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Center)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Center)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Center)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = FileUtils.createImage_((String)"img", (String)((Center)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Center)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Center)this.getElement()).setImage(img);
            ((Center)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }
}

