/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.FileUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Testimonial;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.TestimonialRepository;

@Named
@SessionScoped
public class TestimonialController
extends AbstractLazyController<Testimonial> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/testimonial/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/testimonial/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/testimonial/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/testimonial/edit-image.xhtml";
    @Inject
    @OwnRepository(value=TestimonialRepository.class)
    TestimonialRepository testimonialRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Testimonial t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.exhibitionProducer.reset();
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        this.exhibitionProducer.reset();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.reset();
        return this.listPage();
    }

    public String deleteImg() {
        ((Testimonial)this.getElement()).setImage(null);
        this.testimonialRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Testimonial)this.getElement()).getNewImage().getUploadedData() != null && ((Testimonial)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Testimonial)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Testimonial)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Testimonial)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Testimonial)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Testimonial)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = FileUtils.createImage_((String)"img", (String)((Testimonial)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Testimonial)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Testimonial)this.getElement()).setImage(img);
            ((Testimonial)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }
}

