/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Exhibition;
import org.giavacms.exhibition.repository.ExhibitionRepository;

@Named
@RequestScoped
public class ExhibitionRequestController
extends AbstractRequestController<Exhibition>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXHIBITION = "exhibition";
    public static final String SEARCH = "q";
    public static final String[] PARAM_NAMES = new String[]{"exhibition", "q"};
    public static final String ID_PARAM = "exhibition";
    public static final String CURRENT_PAGE_PARAM = "start";
    @Inject
    @OwnRepository(value=ExhibitionRepository.class)
    ExhibitionRepository exhibitionRepository;

    protected void init() {
        super.init();
    }

    public List<Exhibition> loadPage(int startRow, int pageSize) {
        Search r = new Search(Exhibition.class);
        ((Exhibition)r.getObj()).setName((String)this.getParams().get(SEARCH));
        return this.exhibitionRepository.getList(r, startRow, pageSize);
    }

    public int totalSize() {
        Search r = new Search(Exhibition.class);
        ((Exhibition)r.getObj()).setName((String)this.getParams().get(SEARCH));
        return this.exhibitionRepository.getListSize(r);
    }

    public List<Exhibition> getAll() {
        return this.exhibitionRepository.getAll();
    }

    public String[] getParamNames() {
        return PARAM_NAMES;
    }

    public String getIdParam() {
        return "exhibition";
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((Exhibition)this.getElement()).getId() != null;
    }

    public String viewElement(String id) {
        this.setElement(this.exhibitionRepository.fetch(id));
        return this.viewPage();
    }
}

