/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Discipline;
import org.giavacms.exhibition.model.Exhibition;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.model.pojo.ParticipantExhibition;
import org.giavacms.exhibition.repository.ExhibitionRepository;
import org.giavacms.exhibition.repository.ParticipantRepository;

@Named
@RequestScoped
public class ParticipantRequestController
extends AbstractRequestController<Participant>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXHIBITION = "exhibition";
    public static final String DISCIPLINE = "discipline";
    public static final String YEAR = "year";
    public static final String SUBJECT = "subject";
    public static final String SEARCH = "q";
    public static final String ID_PARAM = "id";
    public static final String CURRENT_PAGE_PARAM = "start";
    public static final String[] PARAM_NAMES = new String[]{"id", "exhibition", "year", "subject", "discipline", "q", "id", "start"};
    private String filter;
    private Exhibition latestExhibition;
    @Inject
    @OwnRepository(value=ParticipantRepository.class)
    ParticipantRepository participantRepository;
    @Inject
    ExhibitionRepository exhibitionRepository;

    protected void init() {
        super.init();
    }

    public List<Participant> loadPage(int startRow, int pageSize) {
        Search r = new Search(Participant.class);
        ((Participant)r.getObj()).getDiscipline().setId((String)this.getParams().get(DISCIPLINE));
        if (this.getParams().get(EXHIBITION) != null && !((String)this.getParams().get(EXHIBITION)).isEmpty()) {
            ((Participant)r.getObj()).getExhibition().setId((String)this.getParams().get(EXHIBITION));
        } else if (this.getLatestExhibition() != null) {
            ((Participant)r.getObj()).getExhibition().setId(this.getLatestExhibition().getId());
        }
        ((Participant)r.getObj()).getSubject().setId((String)this.getParams().get(SUBJECT));
        ((Participant)r.getObj()).getSubject().setSurname((String)this.getParams().get(SEARCH));
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            ((Participant)r.getObj()).getSubject().setType(this.getFilter());
        }
        return this.participantRepository.getList(r, startRow, pageSize);
    }

    public List<ParticipantExhibition> getAllPartecipantsBySubject() {
        return this.participantRepository.getAllPartecipantsBySubject(this.getElement().getSubject().getId());
    }

    public int totalSize() {
        Search r = new Search(Participant.class);
        ((Participant)r.getObj()).getDiscipline().setId((String)this.getParams().get(DISCIPLINE));
        if (this.getParams().get(EXHIBITION) != null && !((String)this.getParams().get(EXHIBITION)).isEmpty()) {
            ((Participant)r.getObj()).getExhibition().setId((String)this.getParams().get(EXHIBITION));
        } else if (this.getLatestExhibition() != null) {
            ((Participant)r.getObj()).getExhibition().setId(this.getLatestExhibition().getId());
        }
        ((Participant)r.getObj()).getSubject().setId((String)this.getParams().get(SUBJECT));
        ((Participant)r.getObj()).getSubject().setSurname((String)this.getParams().get(SEARCH));
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            ((Participant)r.getObj()).getSubject().setType(this.getFilter());
        }
        return this.participantRepository.getListSize(r);
    }

    public List<Participant> getPageOfSizeWithType(int size, String type) {
        this.setFilter(type);
        this.setPageSize(size);
        return this.getPage();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String[] getParamNames() {
        return PARAM_NAMES;
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && this.getElement().getId() != null;
    }

    public String viewElement(Long id) {
        this.setElement(this.participantRepository.fetch(id));
        return this.viewPage();
    }

    public List<Discipline> getDiscipline() {
        return this.participantRepository.getDistinctDiscipline((String)this.getParams().get(EXHIBITION));
    }

    public Participant getElement() {
        if (super.getElement() == null) {
            Participant element = this.participantRepository.findLatestPartcipantBySubjectId((String)this.getParams().get(SUBJECT));
            this.setElement(element);
        }
        return (Participant)this.element;
    }

    public Exhibition getLatestExhibition() {
        if (this.latestExhibition == null) {
            this.latestExhibition = this.exhibitionRepository.getLatest();
        }
        return this.latestExhibition;
    }
}

