/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Publication;
import org.giavacms.exhibition.repository.PublicationRepository;

@Named
@RequestScoped
public class PublicationRequestController
extends AbstractRequestController<Publication>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXHIBITION = "exhibition";
    public static final String AUTHOR = "autor";
    public static final String SEARCH = "q";
    public static final String CURRENT_PAGE_PARAM = "start";
    public static final String ID_PARAM = "id";
    public static final String[] PARAM_NAMES = new String[]{"exhibition", "q", "id", "start", "autor"};
    @Inject
    @OwnRepository(value=PublicationRepository.class)
    PublicationRepository publicationRepository;

    protected void init() {
        super.init();
    }

    public List<Publication> loadPage(int startRow, int pageSize) {
        Search r = new Search(Publication.class);
        ((Publication)r.getObj()).setTitle((String)this.getParams().get(SEARCH));
        ((Publication)r.getObj()).setAuthor((String)this.getParams().get(AUTHOR));
        ((Publication)r.getObj()).getExhibition().setId((String)this.getParams().get(EXHIBITION));
        return this.publicationRepository.getList(r, startRow, pageSize);
    }

    public int totalSize() {
        Search r = new Search(Publication.class);
        ((Publication)r.getObj()).setTitle((String)this.getParams().get(SEARCH));
        ((Publication)r.getObj()).setAuthor((String)this.getParams().get(AUTHOR));
        ((Publication)r.getObj()).getExhibition().setId((String)this.getParams().get(EXHIBITION));
        return this.publicationRepository.getListSize(r);
    }

    public String[] getParamNames() {
        return PARAM_NAMES;
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((Publication)this.getElement()).getId() != null;
    }

    public String viewElement(String id) {
        this.setElement(this.publicationRepository.fetch(id));
        return this.viewPage();
    }
}

