/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.model;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.exhibition.model.Subject;

@Entity
@Table(name="ExhibitionAssociation")
@DiscriminatorValue(value="ASS")
public class Association
extends Subject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "ASS";
    private boolean active = true;
    private Image image;
    private Image newImage;

    public Association() {
        super.setType(TYPE);
    }

    @Transient
    public String getNameSurname() {
        return (this.getName() == null ? "" : this.getName() + " ") + (this.getSurname() == null ? "" : this.getSurname());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="image_id", unique=true, nullable=true, insertable=true, updatable=true)
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Transient
    public Image getNewImage() {
        if (this.newImage == null) {
            this.newImage = new Image();
        }
        return this.newImage;
    }

    public void setNewImage(Image newImage) {
        this.newImage = newImage;
    }

    public String toString() {
        return "Association []";
    }
}

