/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.giavacms.base.model.attachment.Image;

@Entity
@Table(name="Exhibition")
public class Exhibition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String preview;
    private String description;
    private String year;
    private Image image;
    private Image newImage;
    private String catalogue;
    private Image catalogueImage;
    private Image newCatalogueImage;
    private String website;
    private Date date;
    private boolean active = true;
    private String externalImage;
    private String externalCatalogueImage;

    @Id
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Lob
    @Column(length=102400)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="image_id", unique=true, nullable=true, insertable=true, updatable=true)
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Transient
    public Image getNewImage() {
        if (this.newImage == null) {
            this.newImage = new Image();
        }
        return this.newImage;
    }

    public void setNewImage(Image newImage) {
        this.newImage = newImage;
    }

    public String getCatalogue() {
        return this.catalogue;
    }

    public void setCatalogue(String catalogue) {
        this.catalogue = catalogue;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Lob
    @Column(length=102400)
    public String getPreview() {
        return this.preview;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    public String getExternalImage() {
        return this.externalImage;
    }

    public void setExternalImage(String externalImage) {
        this.externalImage = externalImage;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="catalogueImage_id", unique=true, nullable=true, insertable=true, updatable=true)
    public Image getCatalogueImage() {
        if (this.catalogueImage == null) {
            this.catalogueImage = new Image();
        }
        return this.catalogueImage;
    }

    public void setCatalogueImage(Image catalogueImage) {
        this.catalogueImage = catalogueImage;
    }

    @Transient
    public Image getNewCatalogueImage() {
        if (this.newCatalogueImage == null) {
            this.newCatalogueImage = new Image();
        }
        return this.newCatalogueImage;
    }

    public void setNewCatalogueImage(Image newCatalogueImage) {
        this.newCatalogueImage = newCatalogueImage;
    }

    public String getExternalCatalogueImage() {
        return this.externalCatalogueImage;
    }

    public void setExternalCatalogueImage(String externalCatalogueImage) {
        this.externalCatalogueImage = externalCatalogueImage;
    }

    public String toString() {
        return "Exhibition [id=" + this.id + ", name=" + this.name + ", preview=" + this.preview + ", description=" + this.description + ", year=" + this.year + ", website=" + this.website + ", date=" + this.date + "]";
    }
}

