/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.exhibition.model.Exhibition;

@Entity
@Table(name="ExhibitionPublication")
public class Publication
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String author;
    private String title;
    private String preview;
    private String content;
    private String link;
    private Date date;
    private Exhibition exhibition;
    List<Document> documents;
    List<Image> images;
    private boolean active = true;

    @Id
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Lob
    @Column(length=102400)
    public String getPreview() {
        return this.preview;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    @Lob
    @Column(length=102400)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @ManyToOne
    public Exhibition getExhibition() {
        if (this.exhibition == null) {
            this.exhibition = new Exhibition();
        }
        return this.exhibition;
    }

    public void setExhibition(Exhibition exhibition) {
        this.exhibition = exhibition;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ExhibitionPublication_Document", joinColumns={@JoinColumn(name="InsuranceClaimProduct_id")}, inverseJoinColumns={@JoinColumn(name="documents_id")})
    public List<Document> getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public void addDocument(Document document) {
        this.getDocuments().add(document);
    }

    @Transient
    public int getDocSize() {
        return this.getDocuments().size();
    }

    @Transient
    public Image getImage() {
        if (this.getImages() != null && this.getImages().size() > 0) {
            return this.getImages().get(0);
        }
        return null;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ExhibitionPublication_Image", joinColumns={@JoinColumn(name="InsuranceClaimProduct_id")}, inverseJoinColumns={@JoinColumn(name="images_id")})
    public List<Image> getImages() {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public void addImage(Image image) {
        this.getImages().add(image);
    }

    @Transient
    public int getImgSize() {
        return this.getImages().size();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String toString() {
        return "Publication [id=" + this.id + ", author=" + this.author + ", title=" + this.title + ", preview=" + this.preview + ", link=" + this.link + ", date=" + this.date + "]";
    }
}

