/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.enums.ParticipationType;
import org.giavacms.exhibition.model.Artist;
import org.giavacms.exhibition.model.Association;
import org.giavacms.exhibition.model.Center;
import org.giavacms.exhibition.model.Discipline;
import org.giavacms.exhibition.model.Exhibition;
import org.giavacms.exhibition.model.Institute;
import org.giavacms.exhibition.model.Museum;
import org.giavacms.exhibition.model.Sponsor;
import org.giavacms.exhibition.model.Subject;
import org.giavacms.exhibition.model.Testimonial;
import org.giavacms.exhibition.repository.ArtistRepository;
import org.giavacms.exhibition.repository.AssociationRepository;
import org.giavacms.exhibition.repository.CenterRepository;
import org.giavacms.exhibition.repository.DisciplineRepository;
import org.giavacms.exhibition.repository.ExhibitionRepository;
import org.giavacms.exhibition.repository.InstituteRepository;
import org.giavacms.exhibition.repository.MuseumRepository;
import org.giavacms.exhibition.repository.SponsorRepository;
import org.giavacms.exhibition.repository.TestimonialRepository;
import org.jboss.logging.Logger;

@SessionScoped
@Named
public class ExhibitionProducer
implements Serializable {
    Logger logger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Inject
    DisciplineRepository disciplineRepository;
    @Inject
    ExhibitionRepository exhibitionRepository;
    @Inject
    ArtistRepository artistRepository;
    @Inject
    InstituteRepository instituteRepository;
    @Inject
    MuseumRepository museumRepository;
    @Inject
    TestimonialRepository testimonialRepository;
    @Inject
    SponsorRepository sponsorRepository;
    @Inject
    AssociationRepository associationRepository;
    @Inject
    CenterRepository centerRepository;
    private Map<Class, SelectItem[]> items = null;

    @Produces
    @Named
    public SelectItem[] getDisciplineItems() {
        if (this.items.get(Discipline.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona disciplina..."));
            for (Discipline t : this.disciplineRepository.getList(new Search(Discipline.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getName()));
            }
            this.items.put(Discipline.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Discipline.class);
    }

    @Produces
    @Named
    public SelectItem[] getParticipationTypeItems() {
        if (this.items.get(ParticipationType.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona partecipazione..."));
            for (ParticipationType t : ParticipationType.values()) {
                valori.add(new SelectItem((Object)t, t.name()));
            }
            this.items.put(ParticipationType.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(ParticipationType.class);
    }

    @Produces
    @Named
    public SelectItem[] getExhibitionItems() {
        if (this.items.get(Exhibition.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona esibizione..."));
            for (Exhibition t : this.exhibitionRepository.getList(new Search(Exhibition.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getName()));
            }
            this.items.put(Exhibition.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Exhibition.class);
    }

    @Produces
    @Named
    public SelectItem[] getArtistItems() {
        if (this.items.get(Artist.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona artista..."));
            for (Artist t : this.artistRepository.getList(new Search(Artist.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Artist.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Artist.class);
    }

    @Produces
    @Named
    public SelectItem[] getInstituteItems() {
        if (this.items.get(Institute.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona istituti..."));
            for (Institute t : this.instituteRepository.getList(new Search(Institute.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Institute.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Institute.class);
    }

    @Produces
    @Named
    public SelectItem[] getAssociationItems() {
        if (this.items.get(Association.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona associazione..."));
            for (Association t : this.associationRepository.getList(new Search(Association.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Association.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Association.class);
    }

    @Produces
    @Named
    public SelectItem[] getCenterItems() {
        if (this.items.get(Center.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona centri..."));
            for (Center t : this.centerRepository.getList(new Search(Center.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Center.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Center.class);
    }

    @Produces
    @Named
    public SelectItem[] getMuseumItems() {
        if (this.items.get(Museum.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona museo..."));
            for (Museum t : this.museumRepository.getList(new Search(Museum.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Museum.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Museum.class);
    }

    @Produces
    @Named
    public SelectItem[] getTestimonialItems() {
        if (this.items.get(Testimonial.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona testimonial..."));
            for (Testimonial t : this.testimonialRepository.getList(new Search(Testimonial.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Testimonial.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Testimonial.class);
    }

    @Produces
    @Named
    public SelectItem[] getSponsorItems() {
        if (this.items.get(Sponsor.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona sponsor..."));
            for (Sponsor t : this.sponsorRepository.getList(new Search(Sponsor.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getNameSurname()));
            }
            this.items.put(Sponsor.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Sponsor.class);
    }

    @Produces
    @Named
    public SelectItem[] getSubjectTypeItems() {
        if (this.items.get(Subject.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona tipo soggetto..."));
            valori.add(new SelectItem((Object)"ART", "artista"));
            valori.add(new SelectItem((Object)"INS", "istituto"));
            valori.add(new SelectItem((Object)"MUS", "museo"));
            valori.add(new SelectItem((Object)"TES", "testimonial"));
            valori.add(new SelectItem((Object)"SPO", "sponsor"));
            this.items.put(Subject.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(Subject.class);
    }

    public void resetItemsForClass(Class clazz) {
        if (this.items.containsKey(clazz)) {
            this.items.remove(clazz);
        }
    }

    @PostConstruct
    public void reset() {
        this.items = new HashMap<Class, SelectItem[]>();
    }
}

