/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Association;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class AssociationRepository
extends AbstractRepository<Association> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;
    @Inject
    SubjectRepository subjectRepository;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Association prePersist(Association association) {
        String idTitle = PageUtils.createPageId((String)association.getName());
        String idFinal = this.subjectRepository.testKey(idTitle);
        association.setId(idFinal);
        return association;
    }

    protected void applyRestrictions(Search<Association> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Association)search.getObj()).getName() != null && ((Association)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Association)search.getObj()).getName());
        }
    }

    public boolean delete(Object key) {
        try {
            Association association = (Association)this.getEm().find(this.getEntityType(), key);
            if (association != null) {
                association.setActive(false);
                this.getEm().merge((Object)association);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }
}

