/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Center;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class CenterRepository
extends AbstractRepository<Center> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;
    @Inject
    SubjectRepository subjectRepository;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Center prePersist(Center center) {
        String idTitle = PageUtils.createPageId((String)center.getName());
        String idFinal = this.subjectRepository.testKey(idTitle);
        center.setId(idFinal);
        return center;
    }

    protected void applyRestrictions(Search<Center> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Center)search.getObj()).getName() != null && ((Center)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Center)search.getObj()).getName());
        }
    }

    public boolean delete(Object key) {
        try {
            Center center = (Center)this.getEm().find(this.getEntityType(), key);
            if (center != null) {
                center.setActive(false);
                this.getEm().merge((Object)center);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }
}

