/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Exhibition;

@Named
@Stateless
@LocalBean
public class ExhibitionRepository
extends AbstractRepository<Exhibition> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "date desc";
    }

    protected Exhibition prePersist(Exhibition exhibition) {
        String idTitle = PageUtils.createPageId((String)exhibition.getName());
        String idFinal = super.testKey(idTitle);
        exhibition.setDescription(HtmlUtils.normalizeHtml((String)exhibition.getDescription()));
        exhibition.setId(idFinal);
        return exhibition;
    }

    protected Exhibition preUpdate(Exhibition exhibition) {
        exhibition.setDescription(HtmlUtils.normalizeHtml((String)exhibition.getDescription()));
        return (Exhibition)super.preUpdate((Object)exhibition);
    }

    protected void applyRestrictions(Search<Exhibition> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Exhibition)search.getObj()).getId() != null && ((Exhibition)search.getObj()).getId().trim().length() > 0) {
            sb.append(separator).append(alias).append(".id = :ID ");
            params.put("ID", ((Exhibition)search.getObj()).getId());
        }
        if (((Exhibition)search.getObj()).getName() != null && ((Exhibition)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(" upper(" + alias).append(".name) like :NAME ");
            params.put("NAME", this.likeParam(((Exhibition)search.getObj()).getName()));
        }
        if (((Exhibition)search.getObj()).getYear() != null && !((Exhibition)search.getObj()).getYear().isEmpty()) {
            sb.append(separator).append(alias).append(".year = :YEAR ");
            params.put("YEAR", ((Exhibition)search.getObj()).getYear());
        }
    }

    public List<Exhibition> getAll() {
        ArrayList<Exhibition> exhibitions = new ArrayList<Exhibition>();
        for (Object[] row : this.getEm().createNativeQuery("SELECT E.id, E.name FROM `Exhibition` E WHERE E.active = :ACTIVE order by E.date DESC ").setParameter("ACTIVE", (Object)true).getResultList()) {
            int i = 0;
            String id = (String)row[i];
            String name = (String)row[++i];
            Exhibition l = new Exhibition();
            l.setId(id);
            l.setName(name);
            exhibitions.add(l);
        }
        return exhibitions;
    }

    public boolean delete(Object key) {
        try {
            Exhibition exhibition = (Exhibition)this.getEm().find(this.getEntityType(), key);
            if (exhibition != null) {
                exhibition.setActive(false);
                this.getEm().merge((Object)exhibition);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }

    public Exhibition getLatest() {
        Search search = new Search(Exhibition.class);
        List list = this.getList(search, 0, 1);
        if (list != null && list.size() > 0) {
            return (Exhibition)list.get(0);
        }
        return null;
    }
}

