/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Museum;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class MuseumRepository
extends AbstractRepository<Museum> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;
    @Inject
    SubjectRepository subjectRepository;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Museum prePersist(Museum museum) {
        String idTitle = PageUtils.createPageId((String)museum.getName());
        String idFinal = this.subjectRepository.testKey(idTitle);
        museum.setId(idFinal);
        return museum;
    }

    protected void applyRestrictions(Search<Museum> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Museum)search.getObj()).getName() != null && ((Museum)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Museum)search.getObj()).getName());
        }
    }

    public boolean delete(Object key) {
        try {
            Museum museum = (Museum)this.getEm().find(this.getEntityType(), key);
            if (museum != null) {
                museum.setActive(false);
                this.getEm().merge((Object)museum);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }
}

