/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Discipline;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.model.pojo.ParticipantExhibition;

@Named
@Stateless
@LocalBean
public class ParticipantRepository
extends AbstractRepository<Participant> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "subject.surname asc, subject.name asc, id desc";
    }

    protected void applyRestrictions(Search<Participant> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Participant)search.getObj()).getExhibition() != null && ((Participant)search.getObj()).getExhibition().getId() != null && !((Participant)search.getObj()).getExhibition().getId().isEmpty()) {
            sb.append(separator).append(alias).append(".exhibition.id = :EXHIBITION ");
            params.put("EXHIBITION", ((Participant)search.getObj()).getExhibition().getId());
        }
        if (((Participant)search.getObj()).getDiscipline() != null && ((Participant)search.getObj()).getDiscipline().getId() != null && !((Participant)search.getObj()).getDiscipline().getId().isEmpty()) {
            sb.append(separator).append(alias).append(".discipline.id = :DISCIPLINE ");
            params.put("DISCIPLINE", ((Participant)search.getObj()).getDiscipline().getId());
        }
        if (((Participant)search.getObj()).getSubject() != null && ((Participant)search.getObj()).getSubject().getId() != null && !((Participant)search.getObj()).getSubject().getId().isEmpty()) {
            sb.append(separator).append(alias).append(".subject.id = :SUBJECT ");
            params.put("SUBJECT", ((Participant)search.getObj()).getSubject().getId());
        }
        if (((Participant)search.getObj()).getSubject() != null && ((Participant)search.getObj()).getSubject().getSurname() != null && !((Participant)search.getObj()).getSubject().getSurname().isEmpty()) {
            sb.append(separator).append(alias).append(".subject.surname LIKE :SUBJECT_SURNAME ");
            params.put("SUBJECT_SURNAME", this.likeParam(((Participant)search.getObj()).getSubject().getSurname()));
        }
        if (((Participant)search.getObj()).getSubject() != null && ((Participant)search.getObj()).getSubject().getName() != null && !((Participant)search.getObj()).getSubject().getName().isEmpty()) {
            sb.append(separator).append(alias).append(".subject.name LIKE :SUBJECT_NAME ");
            params.put("SUBJECT_NAME", this.likeParam(((Participant)search.getObj()).getSubject().getName()));
        }
        if (((Participant)search.getObj()).getSubject() != null && ((Participant)search.getObj()).getSubject().getType() != null && !((Participant)search.getObj()).getSubject().getType().isEmpty()) {
            sb.append(separator).append(alias).append(".subject.type = :SUBJECT_TYPE ");
            params.put("SUBJECT_TYPE", ((Participant)search.getObj()).getSubject().getType());
        }
    }

    public List<ParticipantExhibition> getAllPartecipantsBySubject(String subjectId) {
        ArrayList<ParticipantExhibition> participantExhibitions = new ArrayList<ParticipantExhibition>();
        for (Object[] row : this.getEm().createNativeQuery("SELECT P.id as partecipant_id, P.subject_id, S.type, E.id as exhibitionId, E.name  FROM `ExhibitionParticipant` P  LEFT JOIN Exhibition E  ON P.exhibition_id= E.id  LEFT JOIN ExhibitionSubject S ON P.subject_id = S.id WHERE P.subject_id = :SUBJECT_ID").setParameter("SUBJECT_ID", (Object)subjectId).getResultList()) {
            int i = 0;
            BigInteger partecipant_id = null;
            if (row[i] instanceof BigInteger) {
                partecipant_id = (BigInteger)row[i];
            }
            String subject_id = (String)row[++i];
            String type = (String)row[++i];
            String id = (String)row[++i];
            String name = (String)row[++i];
            ParticipantExhibition l = new ParticipantExhibition();
            if (partecipant_id != null) {
                l.setPartecipant_id(partecipant_id.longValue());
            }
            l.setSubject_id(subject_id);
            l.setType(type);
            l.setId(id);
            l.setName(name);
            participantExhibitions.add(l);
        }
        return participantExhibitions;
    }

    protected Participant prePersist(Participant participant) {
        if (participant.getDiscipline().getId() == null) {
            participant.setDiscipline(null);
        }
        return (Participant)super.prePersist((Object)participant);
    }

    protected Participant preUpdate(Participant participant) {
        if (participant.getDiscipline().getId() == null) {
            participant.setDiscipline(null);
        }
        return (Participant)super.preUpdate((Object)participant);
    }

    public boolean delete(Object key) {
        try {
            Participant participant = (Participant)this.getEm().find(this.getEntityType(), key);
            if (participant != null) {
                participant.setActive(false);
                this.getEm().merge((Object)participant);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }

    public Participant fetch(Object key) {
        try {
            Long id;
            if (key instanceof String) {
                id = Long.valueOf((String)key);
            } else if (key instanceof Long) {
                id = (Long)key;
            } else {
                throw new Exception("key type is not correct!!");
            }
            Participant participant = (Participant)this.find(id);
            return participant;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return null;
        }
    }

    public Participant findLatestPartcipantBySubjectId(String subjectId) {
        Search s = new Search(Participant.class);
        ((Participant)s.getObj()).getSubject().setId(subjectId);
        List list = this.getList(s, 0, 1);
        if (list != null && list.size() > 0) {
            return (Participant)list.get(0);
        }
        return new Participant();
    }

    public List<Discipline> getDistinctDiscipline(String exhibition) {
        ArrayList<Discipline> disciplines = new ArrayList<Discipline>();
        for (Object[] row : this.getEm().createNativeQuery("SELECT  d.id, d.name, COUNT(d.id) FROM ExhibitionParticipant AS p  LEFT JOIN ExhibitionDiscipline AS d ON ( d.id = p.discipline_id )  WHERE  p.exhibition_id = :EXHIBITION GROUP BY d.id").setParameter("EXHIBITION", (Object)exhibition).getResultList()) {
            Number num;
            Discipline discipline = new Discipline();
            discipline.setId((String)row[0]);
            discipline.setName((String)row[1]);
            if (row[2] instanceof BigInteger) {
                num = (BigInteger)row[2];
                discipline.setNum(((BigInteger)num).intValue());
            } else if (row[2] instanceof Integer) {
                num = (Integer)row[2];
                discipline.setNum((Integer)num);
            }
            disciplines.add(discipline);
        }
        return disciplines;
    }
}

