/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Publication;

@Named
@Stateless
@LocalBean
public class PublicationRepository
extends AbstractRepository<Publication> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "id desc";
    }

    protected Publication prePersist(Publication publication) {
        String idTitle = PageUtils.createPageId((String)publication.getTitle());
        String idFinal = super.testKey(idTitle);
        publication.setContent(HtmlUtils.normalizeHtml((String)publication.getContent()));
        publication.setId(idFinal);
        return publication;
    }

    protected Publication preUpdate(Publication publication) {
        publication.setContent(HtmlUtils.normalizeHtml((String)publication.getContent()));
        return (Publication)super.preUpdate((Object)publication);
    }

    protected void applyRestrictions(Search<Publication> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Publication)search.getObj()).getTitle() != null && ((Publication)search.getObj()).getTitle().trim().length() > 0) {
            sb.append(separator).append(alias).append(".title like :TITLE ");
            params.put("TITLE", this.likeParam(((Publication)search.getObj()).getTitle()));
        }
        if (((Publication)search.getObj()).getAuthor() != null && !((Publication)search.getObj()).getAuthor().isEmpty()) {
            sb.append(separator).append(alias).append(".author = :AUTHOR ");
            params.put("AUTHOR", ((Publication)search.getObj()).getAuthor());
        }
        if (((Publication)search.getObj()).getExhibition() != null && ((Publication)search.getObj()).getExhibition().getId() != null && !((Publication)search.getObj()).getExhibition().getId().isEmpty()) {
            sb.append(separator).append(alias).append(".exhibition.id = :EXHIBITION_ID ");
            params.put("EXHIBITION_ID", ((Publication)search.getObj()).getExhibition().getId());
        }
    }

    public Publication fetch(Object key) {
        try {
            Publication publication = (Publication)this.find(key);
            for (Document document : publication.getDocuments()) {
                document.getName();
            }
            for (Image image : publication.getImages()) {
                image.getName();
            }
            return publication;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return null;
        }
    }

    public boolean delete(Object key) {
        try {
            Publication publication = (Publication)this.getEm().find(this.getEntityType(), key);
            if (publication != null) {
                publication.setActive(false);
                this.getEm().merge((Object)publication);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }
}

