/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Sponsor;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class SponsorRepository
extends AbstractRepository<Sponsor> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;
    @Inject
    SubjectRepository subjectRepository;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Sponsor prePersist(Sponsor sponsor) {
        String idTitle = PageUtils.createPageId((String)sponsor.getName());
        String idFinal = this.subjectRepository.testKey(idTitle);
        sponsor.setId(idFinal);
        return sponsor;
    }

    protected void applyRestrictions(Search<Sponsor> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Sponsor)search.getObj()).getName() != null && ((Sponsor)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Sponsor)search.getObj()).getName());
        }
    }

    public boolean delete(Object key) {
        try {
            Sponsor sponsor = (Sponsor)this.getEm().find(this.getEntityType(), key);
            if (sponsor != null) {
                sponsor.setActive(false);
                this.getEm().merge((Object)sponsor);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }
}

