/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Testimonial;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class TestimonialRepository
extends AbstractRepository<Testimonial> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;
    @Inject
    SubjectRepository subjectRepository;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Testimonial prePersist(Testimonial testimonial) {
        String idTitle = PageUtils.createPageId((String)testimonial.getNameSurname());
        String idFinal = this.subjectRepository.testKey(idTitle);
        testimonial.setId(idFinal);
        return testimonial;
    }

    protected void applyRestrictions(Search<Testimonial> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Testimonial)search.getObj()).getName() != null && ((Testimonial)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Testimonial)search.getObj()).getName());
        }
        if (((Testimonial)search.getObj()).getSurname() != null && !((Testimonial)search.getObj()).getSurname().isEmpty()) {
            sb.append(separator).append(alias).append(".surname LIKE :SURNAME ");
            params.put("SURNAME", this.likeParam(((Testimonial)search.getObj()).getSurname()));
        }
    }

    public boolean delete(Object key) {
        try {
            Testimonial testimonial = (Testimonial)this.getEm().find(this.getEntityType(), key);
            if (testimonial != null) {
                testimonial.setActive(false);
                this.getEm().merge((Object)testimonial);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return false;
        }
    }
}

