/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Artist;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.ArtistRepository;

@Named
@SessionScoped
public class ArtistController
extends AbstractLazyController<Artist> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/artist/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/artist/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/artist/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/artist/edit-image.xhtml";
    @Inject
    @OwnRepository(value=ArtistRepository.class)
    ArtistRepository artistRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Artist t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Artist.class);
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Artist.class);
        return super.save();
    }

    public String saveAndModifyImage() {
        this.saveImage();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        this.exhibitionProducer.reset();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.reset();
        return this.listPage();
    }

    public String deleteImg() {
        ((Artist)this.getElement()).setImage(null);
        this.artistRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Artist)this.getElement()).getNewImage().getUploadedData() != null && ((Artist)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Artist)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Artist)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Artist)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Artist)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Artist)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)((Artist)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Artist)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Artist)this.getElement()).setImage(img);
            ((Artist)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }
}

