/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Association;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.AssociationRepository;

@Named
@SessionScoped
public class AssociationController
extends AbstractLazyController<Association> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/association/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/association/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/association/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/association/edit-image.xhtml";
    @Inject
    @OwnRepository(value=AssociationRepository.class)
    AssociationRepository associationRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Association t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Association.class);
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Association.class);
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.resetItemsForClass(Association.class);
        return this.listPage();
    }

    public String deleteImg() {
        ((Association)this.getElement()).setImage(null);
        this.associationRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Association)this.getElement()).getNewImage().getUploadedData() != null && ((Association)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Association)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Association)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Association)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Association)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Association)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)((Association)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Association)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Association)this.getElement()).setImage(img);
            ((Association)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }
}

