/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import java.util.Date;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Exhibition;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.ExhibitionRepository;

@Named
@SessionScoped
public class ExhibitionController
extends AbstractLazyController<Exhibition> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/edit-image.xhtml";
    @Inject
    @OwnRepository(value=ExhibitionRepository.class)
    ExhibitionRepository exhibitionRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Exhibition t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Exhibition.class);
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        if (((Exhibition)this.getElement()).getDate() == null) {
            ((Exhibition)this.getElement()).setDate(new Date());
        }
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Exhibition.class);
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.reset();
        return this.listPage();
    }

    public String deleteImg() {
        ((Exhibition)this.getElement()).setImage(null);
        this.exhibitionRepository.update(this.getElement());
        return this.listPage();
    }

    public String deleteCatalogueImage() {
        ((Exhibition)this.getElement()).setCatalogueImage(null);
        this.exhibitionRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        String filename;
        Image img;
        if (((Exhibition)this.getElement()).getNewImage().getUploadedData() != null && ((Exhibition)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Exhibition)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Exhibition)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Exhibition)this.getElement()).getNewImage().getUploadedData().getFileName()));
            img = new Image();
            img.setData(((Exhibition)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Exhibition)this.getElement()).getNewImage().getUploadedData().getContentType());
            filename = ResourceUtils.createImage_((String)"img", (String)((Exhibition)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Exhibition)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Exhibition)this.getElement()).setImage(img);
            ((Exhibition)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
        if (((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData() != null && ((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getContents() != null && ((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getFileName() != null && !((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine catalogo: " + ((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getFileName()));
            img = new Image();
            img.setData(((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getContents());
            img.setType(((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getContentType());
            filename = ResourceUtils.createImage_((String)"img", (String)((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getFileName(), (byte[])((Exhibition)this.getElement()).getNewCatalogueImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Exhibition)this.getElement()).setCatalogueImage(img);
            ((Exhibition)this.getElement()).setNewCatalogueImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine catalogo");
        }
    }
}

