/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Museum;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.MuseumRepository;

@Named
@SessionScoped
public class MuseumController
extends AbstractLazyController<Museum> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/museum/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/museum/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/museum/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/museum/edit-image.xhtml";
    @Inject
    @OwnRepository(value=MuseumRepository.class)
    MuseumRepository museumRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Museum t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Museum.class);
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Museum.class);
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        this.exhibitionProducer.resetItemsForClass(Museum.class);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.reset();
        return this.listPage();
    }

    public String deleteImg() {
        ((Museum)this.getElement()).setImage(null);
        this.museumRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Museum)this.getElement()).getNewImage().getUploadedData() != null && ((Museum)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Museum)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Museum)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Museum)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Museum)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Museum)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)((Museum)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Museum)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Museum)this.getElement()).setImage(img);
            ((Museum)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }
}

