/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Artist;
import org.giavacms.exhibition.model.Association;
import org.giavacms.exhibition.model.Center;
import org.giavacms.exhibition.model.Institute;
import org.giavacms.exhibition.model.Museum;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.model.Testimonial;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.ArtistRepository;
import org.giavacms.exhibition.repository.AssociationRepository;
import org.giavacms.exhibition.repository.CenterRepository;
import org.giavacms.exhibition.repository.InstituteRepository;
import org.giavacms.exhibition.repository.MuseumRepository;
import org.giavacms.exhibition.repository.ParticipantRepository;
import org.giavacms.exhibition.repository.TestimonialRepository;

@Named
@SessionScoped
public class ParticipantController
extends AbstractLazyController<Participant> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/participant/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/participant/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/participant/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/participant/edit-image.xhtml";
    public static String EDIT_NEW_SUBJECT = "/private/exhibition/participant/editNewSubject1.xhtml";
    @Inject
    @OwnRepository(value=ParticipantRepository.class)
    ParticipantRepository participantRepository;
    @Inject
    ArtistRepository artistRepository;
    @Inject
    InstituteRepository instituteRepository;
    @Inject
    MuseumRepository museumRepository;
    @Inject
    TestimonialRepository testimonialRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;
    @Inject
    AssociationRepository associationRepository;
    @Inject
    CenterRepository centerRepository;

    public void initController() {
    }

    public Object getId(Participant t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        return this.listPage();
    }

    public String deleteImg() {
        ((Participant)this.getElement()).setImage(null);
        this.participantRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Participant)this.getElement()).getNewImage().getUploadedData() != null && ((Participant)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Participant)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Participant)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Participant)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Participant)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Participant)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)((Participant)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Participant)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Participant)this.getElement()).setImage(img);
            ((Participant)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }

    public String addArtistElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("ART");
        return this.editPage();
    }

    public String addAssociationElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("ASS");
        return this.editPage();
    }

    public String addCenterElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("CEN");
        return this.editPage();
    }

    public String addInstituteElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("INS");
        return this.editPage();
    }

    public String addMuseumElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("MUS");
        return this.editPage();
    }

    public String addTestimonialElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("TES");
        return this.editPage();
    }

    public String addSponsorElement() {
        this.addElement();
        ((Participant)this.getElement()).getSubject().setType("SPO");
        return this.editPage();
    }

    public String addNewSubject() {
        this.addElement();
        return EDIT_NEW_SUBJECT + "?faces-redirect=true";
    }

    public String clone() {
        Participant t = (Participant)this.getModel().getRowData();
        t = (Participant)this.getRepository().fetch(this.getId(t));
        this.addElement();
        ((Participant)this.getElement()).setActive(true);
        ((Participant)this.getElement()).setAddress(t.getAddress());
        ((Participant)this.getElement()).setArtistName(t.getArtistName());
        ((Participant)this.getElement()).setCity(t.getCity());
        ((Participant)this.getElement()).setDate(t.getDate());
        ((Participant)this.getElement()).setDescription(t.getDescription());
        ((Participant)this.getElement()).setDimensions(t.getDimensions());
        ((Participant)this.getElement()).setDiscipline(t.getDiscipline());
        ((Participant)this.getElement()).setEmail(t.getEmail());
        ((Participant)this.getElement()).setExternalImage(t.getExternalImage());
        ((Participant)this.getElement()).setFacebookAccount(t.getFacebookAccount());
        ((Participant)this.getElement()).setImage(new Image());
        ((Participant)this.getElement()).getImage().setActive(true);
        ((Participant)this.getElement()).getImage().setData(t.getImage().getData());
        ((Participant)this.getElement()).getImage().setDescription(t.getImage().getDescription());
        ((Participant)this.getElement()).getImage().setFilename(t.getImage().getFilename());
        ((Participant)this.getElement()).getImage().setName(t.getImage().getName());
        ((Participant)this.getElement()).getImage().setType(t.getImage().getType());
        ((Participant)this.getElement()).setInstagramAccount(t.getInstagramAccount());
        ((Participant)this.getElement()).setMaterial(t.getMaterial());
        ((Participant)this.getElement()).setNewImage(t.getNewImage());
        ((Participant)this.getElement()).setOeuvreTitle(t.getOeuvreTitle());
        ((Participant)this.getElement()).setParticipationType(t.getParticipationType());
        ((Participant)this.getElement()).setPhone(t.getPhone());
        ((Participant)this.getElement()).setProvince(t.getProvince());
        ((Participant)this.getElement()).setSubject(t.getSubject());
        ((Participant)this.getElement()).setSummary(t.getSummary());
        ((Participant)this.getElement()).setTwitterAccount(t.getTwitterAccount());
        ((Participant)this.getElement()).setWebSite(t.getWebSite());
        return EDIT + "?faces-redirect=true";
    }

    public String saveNewSubject() {
        if ("ART".equals(((Participant)this.getElement()).getSubject().getType())) {
            Artist artist = new Artist();
            artist.setName(((Participant)this.getElement()).getSubject().getName());
            artist.setSurname(((Participant)this.getElement()).getSubject().getSurname());
            artist.setArtistName(((Participant)this.getElement()).getArtistName());
            this.artistRepository.persist(artist);
            this.exhibitionProducer.resetItemsForClass(Artist.class);
            this.addElement();
            ((Participant)this.getElement()).setSubject(artist);
        } else if ("INS".equals(((Participant)this.getElement()).getSubject().getType())) {
            Institute institute = new Institute();
            institute.setName(((Participant)this.getElement()).getSubject().getName());
            institute.setSurname(((Participant)this.getElement()).getSubject().getSurname());
            this.instituteRepository.persist(institute);
            this.exhibitionProducer.resetItemsForClass(Institute.class);
            ((Participant)this.getElement()).setSubject(institute);
        } else if ("ASS".equals(((Participant)this.getElement()).getSubject().getType())) {
            Association association = new Association();
            association.setName(((Participant)this.getElement()).getSubject().getName());
            association.setSurname(((Participant)this.getElement()).getSubject().getSurname());
            this.associationRepository.persist(association);
            this.exhibitionProducer.resetItemsForClass(Association.class);
            ((Participant)this.getElement()).setSubject(association);
        } else if ("CEN".equals(((Participant)this.getElement()).getSubject().getType())) {
            Center center = new Center();
            center.setName(((Participant)this.getElement()).getSubject().getName());
            center.setSurname(((Participant)this.getElement()).getSubject().getSurname());
            this.centerRepository.persist(center);
            this.exhibitionProducer.resetItemsForClass(Center.class);
            ((Participant)this.getElement()).setSubject(center);
        } else if ("MUS".equals(((Participant)this.getElement()).getSubject().getType())) {
            Museum museum = new Museum();
            museum.setName(((Participant)this.getElement()).getSubject().getName());
            museum.setSurname(((Participant)this.getElement()).getSubject().getSurname());
            this.museumRepository.persist(museum);
            this.exhibitionProducer.resetItemsForClass(Museum.class);
            this.addElement();
            ((Participant)this.getElement()).setSubject(museum);
        } else if ("TES".equals(((Participant)this.getElement()).getSubject().getType())) {
            Testimonial testimonial = new Testimonial();
            testimonial.setName(((Participant)this.getElement()).getSubject().getName());
            testimonial.setSurname(((Participant)this.getElement()).getSubject().getSurname());
            testimonial.setArtistName(((Participant)this.getElement()).getArtistName());
            this.testimonialRepository.persist(testimonial);
            this.exhibitionProducer.resetItemsForClass(Testimonial.class);
            this.addElement();
            ((Participant)this.getElement()).setSubject(testimonial);
        }
        return EDIT + "?faces-redirect=true";
    }
}

