/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import java.util.ArrayList;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.model.enums.ResourceType;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Publication;
import org.giavacms.exhibition.repository.PublicationRepository;
import org.primefaces.event.FileUploadEvent;

@Named
@SessionScoped
public class PublicationController
extends AbstractLazyController<Publication> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/publication/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/publication/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/publication/edit.xhtml";
    public static String EDIT_DOCS = "/private/exhibition/publication/edit-documents.xhtml";
    @Inject
    @OwnRepository(value=PublicationRepository.class)
    PublicationRepository publicationRepository;

    public void initController() {
    }

    public Object getId(Publication t) {
        return t.getId();
    }

    public String modDocumentsCurrent() {
        super.modCurrent();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public String modDocuments() {
        super.modElement();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public void handleUpload(FileUploadEvent event) {
        this.logger.info((Object)("Uploaded: " + event.getFile().getFileName() + " - " + event.getFile().getContentType() + "- " + event.getFile().getSize()));
        String type = ResourceUtils.getType((String)event.getFile().getFileName());
        if (ResourceType.IMAGE.name().equals(type)) {
            this.handleImgUpload(event);
        } else {
            this.handleFileUpload(event);
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        Document doc = new Document();
        doc.setUploadedData(event.getFile());
        doc.setData(event.getFile().getContents());
        doc.setType(event.getFile().getContentType());
        String filename = ResourceUtils.createFile_((String)"docs", (String)event.getFile().getFileName(), (byte[])event.getFile().getContents());
        doc.setFilename(filename);
        ((Publication)this.getElement()).getDocuments().add(doc);
    }

    public void handleImgUpload(FileUploadEvent event) {
        String type = event.getFile().getFileName().substring(event.getFile().getFileName().lastIndexOf(".") + 1);
        byte[] imgRes = event.getFile().getContents();
        Image img = new Image();
        img.setUploadedData(event.getFile());
        img.setData(imgRes);
        img.setType(event.getFile().getContentType());
        String filename = ResourceUtils.createImage_((String)"img", (String)event.getFile().getFileName(), (byte[])imgRes);
        img.setFilename(filename);
        ((Publication)this.getElement()).getImages().add(img);
    }

    public void removeDocument(Long id) {
        if (id != null && this.getElement() != null && ((Publication)this.getElement()).getDocuments() != null && ((Publication)this.getElement()).getDocuments().size() > 0) {
            ArrayList<Document> docsNew = new ArrayList<Document>();
            for (Document doc : ((Publication)this.getElement()).getDocuments()) {
                if (doc.getId() == null || doc.getId().equals(id)) continue;
                docsNew.add(doc);
            }
            ((Publication)this.getElement()).setDocuments(docsNew);
            this.publicationRepository.update(this.getElement());
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere id:" + id));
        }
    }

    public void removeImage(Long id) {
        if (id != null && this.getElement() != null && ((Publication)this.getElement()).getImages() != null && ((Publication)this.getElement()).getImages().size() > 0) {
            ArrayList<Image> imagesNew = new ArrayList<Image>();
            for (Image img : ((Publication)this.getElement()).getImages()) {
                if (img.getId() == null || img.getId().equals(id)) continue;
                imagesNew.add(img);
            }
            ((Publication)this.getElement()).setImages(imagesNew);
            this.publicationRepository.update(this.getElement());
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere id:" + id));
        }
    }

    public String save() {
        super.save();
        return super.viewPage();
    }

    public String saveAndModDocuments() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public String delete() {
        return super.delete();
    }

    public String update() {
        super.update();
        return super.viewPage();
    }

    public String updateAndmodDocuments() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_DOCS + "?faces-redirect=true";
    }
}

