/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.exhibition.model.Sponsor;
import org.giavacms.exhibition.producer.ExhibitionProducer;
import org.giavacms.exhibition.repository.SponsorRepository;

@Named
@SessionScoped
public class SponsorController
extends AbstractLazyController<Sponsor> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/exhibition/sponsor/view.xhtml";
    @ListPage
    public static String LIST = "/private/exhibition/sponsor/list.xhtml";
    @EditPage
    public static String EDIT = "/private/exhibition/sponsor/edit.xhtml";
    public static String EDIT_IMAGE = "/private/exhibition/sponsor/edit-image.xhtml";
    @Inject
    @OwnRepository(value=SponsorRepository.class)
    SponsorRepository sponsorRepository;
    @Inject
    ExhibitionProducer exhibitionProducer;

    public void initController() {
    }

    public Object getId(Sponsor t) {
        return t.getId();
    }

    public String update() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Sponsor.class);
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.exhibitionProducer.resetItemsForClass(Sponsor.class);
        return super.save();
    }

    public String saveAndModifyImage() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        this.exhibitionProducer.resetItemsForClass(Sponsor.class);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.exhibitionProducer.reset();
        return this.listPage();
    }

    public String deleteImg() {
        ((Sponsor)this.getElement()).setImage(null);
        this.sponsorRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((Sponsor)this.getElement()).getNewImage().getUploadedData() != null && ((Sponsor)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((Sponsor)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((Sponsor)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((Sponsor)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((Sponsor)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((Sponsor)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)((Sponsor)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((Sponsor)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((Sponsor)this.getElement()).setImage(img);
            ((Sponsor)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }
}

