/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Center;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.repository.ArtistRepository;
import org.giavacms.exhibition.repository.CenterRepository;
import org.giavacms.exhibition.service.ParticipantService;

@Named
@RequestScoped
public class CenterRequestController
extends AbstractRequestController<Center>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ID_PARAM = "center";
    public static final String CURRENT_PAGE_PARAM = "start";
    @Inject
    @OwnRepository(value=ArtistRepository.class)
    CenterRepository centerRepository;
    @Inject
    ParticipantService participantService;
    @Inject
    @HttpParam(value="q")
    String search;
    @Inject
    @HttpParam(value="center")
    String id;
    @Inject
    @HttpParam(value="start")
    String start;
    @Inject
    @HttpParam(value="exhibition")
    String exhibition;
    Search<Participant> customSearch = new Search(Participant.class);

    protected void initSearch() {
        ((Participant)this.customSearch.getObj()).getSubject().setType("CEN");
        ((Participant)this.customSearch.getObj()).getExhibition().setId(this.exhibition);
        ((Participant)this.customSearch.getObj()).getSubject().setSurname(this.search);
        super.initSearch();
    }

    public List<Center> loadPage(int startRow, int pageSize) {
        return this.participantService.getList(this.customSearch, startRow, pageSize);
    }

    public int totalSize() {
        return this.participantService.getListSize(this.customSearch);
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((Center)this.getElement()).getId() != null;
    }
}

