/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Institute;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.repository.InstituteRepository;
import org.giavacms.exhibition.service.ParticipantService;

@Named
@RequestScoped
public class InstituteRequestController
extends AbstractRequestController<Institute>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ID_PARAM = "institute";
    public static final String CURRENT_PAGE_PARAM = "start";
    @Inject
    @HttpParam(value="q")
    String search;
    @Inject
    @HttpParam(value="institute")
    String id;
    @Inject
    @HttpParam(value="start")
    String start;
    @Inject
    @HttpParam(value="exhibition")
    String exhibition;
    Search<Participant> customSearch = new Search(Participant.class);
    @Inject
    @OwnRepository(value=InstituteRepository.class)
    InstituteRepository instituteRepository;
    @Inject
    ParticipantService participantService;

    protected void initSearch() {
        ((Participant)this.customSearch.getObj()).getSubject().setType("INS");
        ((Participant)this.customSearch.getObj()).getExhibition().setId(this.exhibition);
        ((Participant)this.customSearch.getObj()).getSubject().setSurname(this.search);
        super.initSearch();
    }

    public List<Institute> loadPage(int startRow, int pageSize) {
        return this.participantService.getList(this.customSearch, startRow, pageSize);
    }

    public int totalSize() {
        return this.participantService.getListSize(this.customSearch);
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((Institute)this.getElement()).getId() != null;
    }
}

