/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Museum;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.repository.MuseumRepository;
import org.giavacms.exhibition.service.ParticipantService;

@Named
@RequestScoped
public class MuseumRequestController
extends AbstractRequestController<Museum>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ID_PARAM = "museum";
    public static final String CURRENT_PAGE_PARAM = "start";
    @Inject
    @HttpParam(value="q")
    String search;
    @Inject
    @HttpParam(value="museum")
    String id;
    @Inject
    @HttpParam(value="start")
    String start;
    @Inject
    @HttpParam(value="exhibition")
    String exhibition;
    Search<Participant> customSearch = new Search(Participant.class);
    @Inject
    @OwnRepository(value=MuseumRepository.class)
    MuseumRepository museumRepository;
    @Inject
    ParticipantService participantService;

    protected void initSearch() {
        ((Participant)this.customSearch.getObj()).getSubject().setType("MUS");
        ((Participant)this.customSearch.getObj()).getExhibition().setId(this.exhibition);
        ((Participant)this.customSearch.getObj()).getSubject().setSurname(this.search);
        super.initSearch();
    }

    public List<Museum> loadPage(int startRow, int pageSize) {
        return this.participantService.getList(this.customSearch, startRow, pageSize);
    }

    public int totalSize() {
        return this.participantService.getListSize(this.customSearch);
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((Museum)this.getElement()).getId() != null;
    }
}

