/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.exhibition.model.Discipline;
import org.giavacms.exhibition.model.Exhibition;
import org.giavacms.exhibition.model.Participant;
import org.giavacms.exhibition.model.pojo.ParticipantExhibition;
import org.giavacms.exhibition.repository.ExhibitionRepository;
import org.giavacms.exhibition.repository.ParticipantRepository;

@Named
@RequestScoped
public class ParticipantRequestController
extends AbstractRequestController<Participant>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXHIBITION = "exhibition";
    public static final String DISCIPLINE = "discipline";
    public static final String YEAR = "year";
    public static final String SUBJECT = "subject";
    public static final String SEARCH = "q";
    public static final String ID_PARAM = "id";
    public static final String CURRENT_PAGE_PARAM = "start";
    private String filter;
    private Exhibition latestExhibition;
    @Inject
    @HttpParam(value="id")
    String id;
    @Inject
    @HttpParam(value="q")
    String search;
    @Inject
    @HttpParam(value="exhibition")
    String exhibition;
    @Inject
    @HttpParam(value="discipline")
    String discipline;
    @Inject
    @HttpParam(value="subject")
    String subject;
    @Inject
    @OwnRepository(value=ParticipantRepository.class)
    ParticipantRepository participantRepository;
    @Inject
    ExhibitionRepository exhibitionRepository;

    protected void initSearch() {
        Search r = this.getSearch();
        ((Participant)r.getObj()).getDiscipline().setId(this.discipline);
        if (this.exhibition != null && !this.exhibition.isEmpty()) {
            ((Participant)r.getObj()).getExhibition().setId(this.exhibition);
        } else if (this.getLatestExhibition() != null) {
            ((Participant)r.getObj()).getExhibition().setId(this.getLatestExhibition().getId());
        }
        ((Participant)r.getObj()).getSubject().setId(this.subject);
        ((Participant)r.getObj()).getSubject().setSurname(this.search);
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            ((Participant)r.getObj()).getSubject().setType(this.getFilter());
        }
        super.initSearch();
    }

    public List<ParticipantExhibition> getAllPartecipantsBySubject() {
        return this.participantRepository.getAllPartecipantsBySubject(this.getElement().getSubject().getId());
    }

    public List<Participant> getPageOfSizeWithType(int size, String type) {
        this.setFilter(type);
        this.setPageSize(size);
        return this.getPage();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && this.getElement().getId() != null;
    }

    public List<Discipline> getDiscipline() {
        return this.participantRepository.getDistinctDiscipline(this.exhibition);
    }

    public Participant getElement() {
        if (super.getElement() == null) {
            Participant element = this.participantRepository.findLatestPartcipantBySubjectId(this.subject);
            this.setElement(element);
        }
        return (Participant)this.element;
    }

    public Exhibition getLatestExhibition() {
        if (this.latestExhibition == null) {
            this.latestExhibition = this.exhibitionRepository.getLatest();
        }
        return this.latestExhibition;
    }
}

