/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.model;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.util.StringUtils;
import org.giavacms.exhibition.enums.ParticipationType;
import org.giavacms.exhibition.model.Discipline;
import org.giavacms.exhibition.model.Exhibition;
import org.giavacms.exhibition.model.Subject;

@Entity
@Table(name="ExhibitionParticipant")
public class Participant
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Exhibition exhibition;
    private Subject subject;
    private String description;
    private String artistName;
    private String address;
    private String city;
    private String province;
    private String phone;
    private String email;
    private String oeuvreTitle;
    private String dimensions;
    private String material;
    private String summary;
    private Discipline discipline;
    private ParticipationType participationType;
    private String webSite;
    private String facebookAccount;
    private String twitterAccount;
    private String instagramAccount;
    private Image image;
    private Image newImage;
    private String externalImage;
    private String date;
    private boolean active = true;
    private boolean toControl = false;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne
    public Subject getSubject() {
        if (this.subject == null) {
            this.subject = new Subject();
        }
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    @ManyToOne
    public Exhibition getExhibition() {
        if (this.exhibition == null) {
            this.exhibition = new Exhibition();
        }
        return this.exhibition;
    }

    public void setExhibition(Exhibition exhibition) {
        this.exhibition = exhibition;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    @Lob
    @Column(length=102400)
    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="Discipline_id", nullable=true)
    public Discipline getDiscipline() {
        if (this.discipline == null) {
            this.discipline = new Discipline();
        }
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    public String getFacebookAccount() {
        return this.facebookAccount;
    }

    public void setFacebookAccount(String facebookAccount) {
        this.facebookAccount = facebookAccount;
    }

    public String getInstagramAccount() {
        return this.instagramAccount;
    }

    public void setInstagramAccount(String instagramAccount) {
        this.instagramAccount = instagramAccount;
    }

    public String getExternalImage() {
        return this.externalImage;
    }

    public void setExternalImage(String externalImage) {
        this.externalImage = externalImage;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="image_id", unique=true, nullable=true, insertable=true, updatable=true)
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Transient
    public Image getNewImage() {
        if (this.newImage == null) {
            this.newImage = new Image();
        }
        return this.newImage;
    }

    public void setNewImage(Image newImage) {
        this.newImage = newImage;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOeuvreTitle() {
        return this.oeuvreTitle;
    }

    public void setOeuvreTitle(String oeuvreTitle) {
        this.oeuvreTitle = oeuvreTitle;
    }

    @Lob
    @Column(length=102400)
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Enumerated(value=EnumType.STRING)
    public ParticipationType getParticipationType() {
        return this.participationType;
    }

    public void setParticipationType(ParticipationType participationType) {
        this.participationType = participationType;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public void setWebSite(String webSite) {
        this.webSite = webSite;
    }

    public String getTwitterAccount() {
        return this.twitterAccount;
    }

    public void setTwitterAccount(String twitterAccount) {
        this.twitterAccount = twitterAccount;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Lob
    public String getDescription() {
        return this.description;
    }

    @Transient
    public String getPreview() {
        if (this.description != null && this.description.length() > 200) {
            String noHTMLString = StringUtils.trim((String)this.description.replaceAll("\\<.*?\\>", ""), (int)200);
            return noHTMLString;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    @Transient
    public String getArtistName() {
        return this.artistName;
    }

    public void setArtistName(String artistName) {
        this.artistName = artistName;
    }

    public String toString() {
        return "Participant [id=" + this.id + ", exhibition=" + this.exhibition.getName() + ", subject=" + this.subject.getName() + ", description=" + this.description + ", phone=" + this.phone + ", email=" + this.email + ", oeuvreTitle=" + this.oeuvreTitle + ", dimensions=" + this.dimensions + ", material=" + this.material + ", summary=" + this.summary + ", discipline=" + this.discipline + ", participationType=" + (Object)((Object)this.participationType) + ", webSite=" + this.webSite + ", facebookAccount=" + this.facebookAccount + ", twitterAccount=" + this.twitterAccount + ", instagramAccount=" + this.instagramAccount + ", date=" + this.date + "]";
    }

    public boolean isToControl() {
        return this.toControl;
    }

    public void setToControl(boolean toControl) {
        this.toControl = toControl;
    }
}

