/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Artist;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class ArtistRepository
extends AbstractRepository<Artist> {
    private static final long serialVersionUID = 1L;
    @Inject
    SubjectRepository subjectRepository;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Artist prePersist(Artist artist) {
        String idTitle = PageUtils.createPageId((String)artist.getNameSurname());
        String idFinal = this.subjectRepository.testKey(idTitle);
        artist.setId(idFinal);
        return artist;
    }

    protected void applyRestrictions(Search<Artist> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Artist)search.getObj()).getName() != null && ((Artist)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Artist)search.getObj()).getName());
        }
        if (((Artist)search.getObj()).getSurname() != null && !((Artist)search.getObj()).getSurname().isEmpty()) {
            sb.append(separator).append(alias).append(".surname LIKE :SURNAME ");
            params.put("SURNAME", this.likeParam(((Artist)search.getObj()).getSurname()));
        }
    }

    public boolean delete(Object key) {
        try {
            Artist artist = (Artist)this.getEm().find(this.getEntityType(), key);
            if (artist != null) {
                artist.setActive(false);
                this.getEm().merge((Object)artist);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

