/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.exhibition.repository;

import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.controller.util.PageUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.exhibition.model.Institute;
import org.giavacms.exhibition.repository.SubjectRepository;

@Named
@Stateless
@LocalBean
public class InstituteRepository
extends AbstractRepository<Institute> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;
    @Inject
    SubjectRepository subjectRepository;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "surname asc";
    }

    protected Institute prePersist(Institute institute) {
        String idTitle = PageUtils.createPageId((String)institute.getName());
        String idFinal = this.subjectRepository.testKey(idTitle);
        institute.setId(idFinal);
        return institute;
    }

    protected void applyRestrictions(Search<Institute> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((Institute)search.getObj()).getName() != null && ((Institute)search.getObj()).getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".name = :NAME ");
            params.put("NAME", ((Institute)search.getObj()).getName());
        }
    }

    public boolean delete(Object key) {
        try {
            Institute institute = (Institute)this.getEm().find(this.getEntityType(), key);
            if (institute != null) {
                institute.setActive(false);
                this.getEm().merge((Object)institute);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

