/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.faq.repository;

import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.faq.model.Faq;

@Named
@Stateless
@LocalBean
public class FaqRepository
extends AbstractRepository<Faq> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "date asc";
    }

    public Faq fetch(Object key) {
        try {
            Long id;
            if (key instanceof String) {
                id = Long.valueOf((String)key);
            } else if (key instanceof Long) {
                id = (Long)key;
            } else {
                throw new Exception("key type is not correct!!");
            }
            Faq product = (Faq)this.find(id);
            return product;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return null;
        }
    }

    protected void applyRestrictions(Search<Faq> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        sb.append(separator).append(alias).append(".faqCategory.active = :activeCategory");
        params.put("activeCategory", true);
        separator = " and ";
        if (((Faq)search.getObj()).getFaqCategory() != null && ((Faq)search.getObj()).getFaqCategory().getName() != null && ((Faq)search.getObj()).getFaqCategory().getName().trim().length() > 0) {
            sb.append(separator).append(alias).append(".faqCategory.name = :NAMECAT ");
            params.put("NAMECAT", ((Faq)search.getObj()).getFaqCategory().getName());
        }
        if (((Faq)search.getObj()).getFaqCategory() != null && ((Faq)search.getObj()).getFaqCategory().getId() != null && ((Faq)search.getObj()).getFaqCategory().getId() > 0L) {
            sb.append(separator).append(alias).append(".faqCategory.id = :IDCAT ");
            params.put("IDCAT", ((Faq)search.getObj()).getFaqCategory().getId());
        }
        if (((Faq)search.getObj()).getAnswer() != null && !((Faq)search.getObj()).getAnswer().isEmpty()) {
            sb.append(separator + " upper(").append(alias).append(".answer) LIKE :ANSWER ");
            params.put("ANSWER", this.likeParam(((Faq)search.getObj()).getAnswer().toUpperCase()));
        }
        if (((Faq)search.getObj()).getQuestion() != null && !((Faq)search.getObj()).getQuestion().isEmpty()) {
            sb.append(separator + " upper(").append(alias).append(".question) LIKE :QUESTION ");
            params.put("QUESTION", this.likeParam(((Faq)search.getObj()).getQuestion().toUpperCase()));
        }
    }

    protected Faq prePersist(Faq faq) {
        faq.setAnswer(HtmlUtils.normalizeHtml((String)faq.getAnswer()));
        faq.setQuestion(HtmlUtils.normalizeHtml((String)faq.getQuestion()));
        return faq;
    }

    protected Faq preUpdate(Faq faq) {
        faq.setAnswer(HtmlUtils.normalizeHtml((String)faq.getAnswer()));
        faq.setQuestion(HtmlUtils.normalizeHtml((String)faq.getQuestion()));
        return faq;
    }
}

