/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.faq.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.controller.AbstractPageRequestController;
import org.giavacms.base.pojo.I18nRequestParams;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.model.Search;
import org.giavacms.faq.model.Faq;
import org.giavacms.faq.model.FaqCategory;
import org.giavacms.faq.repository.FaqCategoryRepository;
import org.giavacms.faq.repository.FaqRepository;

@Named
@RequestScoped
public class FaqRequestController
extends AbstractPageRequestController<Faq>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ID_PARAM = "id";
    public static final String CURRENT_PAGE_PARAM = "f_p";
    public static final String CATEGORY_PARAM = "f_c";
    public static final String SEARCH_PARAM = "f_q";
    @Inject
    @HttpParam(value="f_c")
    String category;
    @Inject
    @HttpParam(value="f_q")
    String search;
    @Inject
    @HttpParam(value="id")
    String id;
    @Inject
    @HttpParam(value="f_p")
    String start;
    @Inject
    @OwnRepository(value=FaqRepository.class)
    FaqRepository faqRepository;
    @Inject
    FaqCategoryRepository faqCategoryRepository;

    public List<FaqCategory> getFaqCategories() {
        Search r = new Search(FaqCategory.class);
        ((FaqCategory)((Object)r.getObj())).setLang(super.getBasePage().getLang());
        return this.faqCategoryRepository.getList(r, 0, 0);
    }

    protected void initSearch() {
        ((Faq)((Object)super.getSearch().getObj())).setTitle(this.search);
        ((Faq)((Object)super.getSearch().getObj())).getFaqCategory().setId(this.category);
        super.initSearch();
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((Faq)((Object)this.getElement())).getId() != null;
    }

    protected void handleI18N() {
        int currentLang;
        I18nRequestParams i18nRequestParams = super.getI18nRequestParams();
        String currentLangValue = i18nRequestParams.get(currentLang = this.getBasePage().getLang(), CATEGORY_PARAM);
        if (currentLangValue != null && currentLangValue.trim().length() > 0) {
            for (int i = 0; i < i18nRequestParams.getLanguages().length; ++i) {
                if (i == currentLang) continue;
                i18nRequestParams.put(i, CATEGORY_PARAM, i18nRequestParams.getLanguages()[i] == null || !i18nRequestParams.getLanguages()[i].isEnabled() ? "n.a." : this.faqCategoryRepository.translate(currentLangValue, currentLang, i, currentLangValue));
            }
        }
    }
}

