/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.faq.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.giavacms.base.model.Page;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.faq.model.Faq;

@Entity
@DiscriminatorValue(value="FaqCategory")
@Table(name="FaqCategory")
public class FaqCategory
extends Page {
    private static final long serialVersionUID = 1L;
    public static final String EXTENSION = "FaqCategory";
    public static final String TABLE_NAME = "FaqCategory";
    public static final boolean HAS_DETAILS = true;
    private Image image;
    private Image newImage;
    private List<Faq> faqs;
    private int orderNum;

    public FaqCategory() {
        super.setExtension("FaqCategory");
    }

    @Transient
    @Deprecated
    public String getName() {
        return super.getTitle();
    }

    @Deprecated
    public void setName(String name) {
        super.setTitle(name);
    }

    @OneToMany(mappedBy="faqCategory", fetch=FetchType.LAZY)
    @OrderBy(value="title")
    public List<Faq> getFaqs() {
        if (this.faqs == null) {
            this.faqs = new ArrayList<Faq>();
        }
        return this.faqs;
    }

    public void setFaqs(List<Faq> faqs) {
        this.faqs = faqs;
    }

    public void addFaq(Faq faq) {
        this.getFaqs().add(faq);
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="image_id", unique=true, nullable=true, insertable=true, updatable=true)
    public Image getImage() {
        if (this.image == null) {
            this.image = new Image();
        }
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Transient
    public Image getNewImage() {
        if (this.newImage == null) {
            this.newImage = new Image();
        }
        return this.newImage;
    }

    public void setNewImage(Image newImage) {
        this.newImage = newImage;
    }

    public String toString() {
        return "FaqCategory [id=" + super.getId() + ", name=" + super.getTitle() + ", description=" + super.getDescription() + ", active=" + super.isActive() + ", orderNum=" + this.orderNum + "]";
    }
}

